/*======================================================================*/
/* 3DPanel header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Aug-01 23:04:01					*/
/*									*/
/* 3DPanel(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DStatusPanel_h
#define _E3DStatusPanel_h


#include <EGUI/EGUI.h>
#include <EGUI/Menu.h>


#ifndef _E3DScene_h
#include <E3D/Scene.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



/*------------------------------*/
/* From Panel/StatusPanel.c	*/
/*------------------------------*/
extern Widget		E3d_UndoBufferDisplayW;

extern void		E3dp_SetProgressMessage(char* LMessage, ...);
extern void		E3dp_SetProgressIndicator(int LThousandth, void (*LAbortCallback)(EPointer), EPointer LClientData);

extern void		E3dp_SetStatusPanel(E3dPanel* L3DPanel, EBool LSwitch);
extern unsigned long	E3dp_PrintMessage(int LType, unsigned int LTime, char* LMessage,...);
extern unsigned long	E3dp_SetCurrentMessage(int LType, unsigned int LTime, char* LMessage, ...);

extern unsigned long	E3dp_PushMessage(int LType, unsigned int LTime, char* LMessage, ...);
extern unsigned long	E3dp_PushHTMLMessage(int LType, unsigned int LTime, char* LMessage, ...);
extern unsigned long	E3dp_PushXeMessage(int LType, unsigned int LTime, XeString LMessage);

extern void		E3dp_PopMessage();

extern void		E3dp_ClearCurrentMessage();
extern void		E3dp_ResetMessageStack();


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DStatusPanel_h
