/*==============================================================*/
/* Directory library header file				*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1995-Dec-25 19:55:06				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EDir_h
#define _EDir_h

#include <stdarg.h>		// For varargs
#include <sys/types.h>
#include <sys/stat.h>

#include <EParam.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#ifdef WIN32
#include <dos.h>
#include <dir.h>
#endif

#ifdef UNIX
#include <sys/dir.h>
#endif

#include <time.h>
#include <stdlib.h>

#include <EStrings.h>


#ifdef UNIX
#ifdef sgi
#include <sys/statvfs.h>
#endif
#endif

enum
{
 EdirIO_OK=0,
 EdirIO_ERROR,
 EdirIO_NO_MEMORY,
 EdirIO_CANT_GET_DIRINFO,
 EdirIO_UNRELSOLVABLE_LINK,
 EdirIO_NFS_DIRECTORY
};

#define EdirENTRY_ALLOC_STEP	16

#define	MAX_LINELEN	512

enum { EdirSORT_ALPHA=0, EdirSORT_TIME, EdirSORT_SIZE };
enum { EdirENTRY_NORMAL=0, EdirENTRY_CURRENT_DIR, EdirENTRY_PARENT_DIR };

// Flags to determine what to display in the directory list
//
#define EdirATTR_FLAGS		1
#define EdirUSER		(1<<1)
#define EdirGROUP		(2<<1)
#define EdirNUM_OF_LINKS	(3<<1)
#define EdirSIZE		(4<<1)
#define EdirDIR_SIZE		(5<<1)
#define EdirTIME		(6<<1)


#define EdirFILE_FILTER_CASE_SENSITIVE	1
#define EdirDIR_FILTER_CASE_SENSITIVE	(1<<1)

typedef struct
{
 int		IsDir, IsNFS;
 nlink_t	NumOfLinks;
 uid_t		UID;
 gid_t		GID;
 size_t		Size;
 mode_t		Mode;
 time_t		ATime, CTime, MTime;
 char		Name[MAXPATHLEN];
#ifdef UNIX
 size_t		RealSize;			// In case it's a symbolic link
 char		RealName[MAXPATHLEN];		//
#endif
} EdirDirEnt;

#ifndef _EDir_c
extern EBool		EDir_ShowCurrentDir, EDir_ShowParentDir,
			EDir_DisplayDirSizes, EDir_ComputeDirSizes, EDir_ComputeCurrentDirSize, EDir_ComputeParentDirSize,
			EDir_DoNFS, EDir_ShowNFSDirs, EDir_FollowLinks;

extern EStrFilterTokens	EDir_UNIXFilterTokens;	// Filter token strings for UNIX "*" "[" "]"


extern int		EDir_SortOrder;

extern time_t		EDir_CurrentTime;
extern int		EDir_ThisYear;

extern char		EDir_Months[][4];

extern int		EDir_Max_EntryNum;

extern int		EDir_GetDir(register char* LEntryName, int LFlags, void* LDirFilterIn, void* LFileFilterIn, EStrFilterTokens* LFilterTokens, EdirDirEnt** LEntriesPtr, unsigned int* LNumOfEntriesPtr, unsigned int* LNumOfDirsPtr, unsigned int* LMaxNumOfEntriesPtr, unsigned long* LTotalSizeRet);

extern int		Edir_GetSizeOfDir(char* LDirectory, EBool LDoNFS, EBool LDoSymLinks, unsigned long* LFullSizeRet, unsigned long* LNumOfFilesRet, unsigned long* LNumOfDirsRet);

extern EBool		EDir_TimeToString(time_t LTime, char* LString);


#endif // _EDir_c

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EDir_h
