/*======================================================================*/
/* Platform independent GUI API header					*/
/*									*/
/* Public header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-24 23:03:07					*/
/*									*/
/* EGUI library Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _EGUI_h
#define _EGUI_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#include <EParam.h>
#include <EInput.h>
#include <Color/Color.h>

#ifdef UNIX

#define EGUIXe
#include <Xe/Xe.h>

#ifdef _XeUSEXm
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#endif

#endif

#include <EGUI/StrDefs.h>

// The typedef for EArgVal should be chosen such that
//
//	sizeof (EArgVal) >=	sizeof(EPointer)
//				sizeof(char*)
//				sizeof(long)
//				sizeof(int*)
//				sizeof(proc*)
//

#ifdef CRAY
typedef char*		EArgVal;
#else
typedef long		EArgVal;
#endif


#include <EStrings.h>
#include <EGUI/StrDefs.h>


// Item types
//
enum
{
 EguiFORM=1,
 EguiMATRIX
};


/*--------------------------------------*/
/* Return status values			*/
/*--------------------------------------*/
enum
{
 EGUI_OK=0,
 EGUI_COULDNT_CREATE_APPCONTEXT,
 EGUI_COULDNT_OPEN_DISPLAY
};



/*--------------------------------------*/
/* For XPMToPixmap ext. color names	*/
/*--------------------------------------*/
typedef struct
{
 char*	Name;
 Pixel*	Value;
} EguiColorEntry;

#define EguiSetArg(n, d, al, ac)	(al)[ac].Name=(n), (al)[ac].Value=(EArgVal)(d), (ac)++

#define EXtStart	ArgCnt=0
#define EXtSetArg(n, d)	Args[ArgCnt].name=(n), Args[ArgCnt].value=(XtArgVal)(d), ArgCnt++

extern int		EGUI_ScreenXSize, EGUI_ScreenYSize;

extern EcRGBAiColor	EGUI_BlackRGBAiColor, EGUI_WhiteRGBAiColor,
			EGUI_BackgroundRGBAiColor, EGUI_ButtonRGBAiColor, EGUI_ForegroundRGBAiColor,
			EGUI_ToolTipBackgroundRGBAiColor;

#ifdef EGUIXe
extern Pixel		EGUI_Black, EGUI_BackgroundColor, EGUI_ForegroundColor,
			EGUI_ButtonColor, EGUI_OptionMenuColor,
			EGUI_ActiveColor,
			EGUI_TopShadowColor, EGUI_BottomShadowColor, EGUI_TroughColor,
			EGUI_WBackgroundColor, EGUI_WTroughColor, EGUI_WForegroundColor, EGUI_WTopShadowColor, EGUI_WBottomShadowColor,
			EGUI_TextFieldBackgroundColor, EGUI_TextFieldForegroundColor, EGUI_TextFieldFocusColor,
			EGUI_HighlightColor, EGUI_ProgressIndicatorColor;

extern Pixel		EGUI_TCBlack, EGUI_TCBackgroundColor, EGUI_TCForegroundColor,
			EGUI_TCButtonColor, EGUI_TCOptionMenuColor,
			EGUI_TCActiveColor,
			EGUI_TCTopShadowColor, EGUI_TCBottomShadowColor, EGUI_TCTroughColor,
			EGUI_TCWBackgroundColor, EGUI_TCWTroughColor, EGUI_TCWForegroundColor, EGUI_TCWTopShadowColor, EGUI_TCWBottomShadowColor,
			EGUI_TCTextFieldBackgroundColor, EGUI_TCTextFieldForegroundColor, EGUI_TCTextFieldFocusColor,
			EGUI_TCHighlightColor, EGUI_TCProgressIndicatorColor;

#endif // EGUIXe

enum { EguiATTACH_NONE=0, EguiATTACH_FORM, EguiATTACH_OBJECT };

enum { EguiLOCATION_NOT_DEFINED=0, EguiLOCATION_CUSTOM0 };

// Orientations
//
enum
{
 EguiHORIZONTAL=0, EguiVERTICAL
};


// Truecolor pixel formats
//
enum
{
 EguiTC_NONE=0,		// Not determined yet
 EguiTC_XBGR_8,		// Z-pixmap type, 8 bits/channel: XXXXXXXXBBBBBBBBGGGGGGGGRRRRRRRR
 EguiTC_RGB_8,		// Z-pixmap type, 8 bits/channel: RRRRRRRRGGGGGGGGBBBBBBBB
 EguiTC_RGB_555,	// Z-pixmap type, 5 bits/channel: XRRRRRGGGGGBBBBB
 EguiTC_RGB_565,	// Z-pixmap type, 5-6-5 bits/channel: RRRRRGGGGGGBBBBB
 EguiTC_RGB_4,		// Z-pixmap type, 4 bits/channel: XXXXRRRRGGGGBBBB
 EguiTC_RGB_332		// Z-pixmap type, 3-3-2 bits/channel: RRRGGGBB
};

// Callback reasons
//
enum
{
 ECR_NONE=0,
 ECR_ACTIVATE,
 ECR_OPTIONS,
 ECR_DRAG,ECR_DROP,
 ECR_POPUP_MENU,
 ECR_BUTTONPRESS,
 ECR_BUTTONRELEASE,
 ECR_KEYPRESS,
 ECR_KEYRELEASE,
 EGUICR_OK,
 EGUICR_CANCEL
};

enum
{
 EInNONE=0,
 EInBUTTON1,
 EInBUTTON2,
 EInBUTTON3,
 EInBUTTON4,
 EInBUTTON5,
 EInKEY
};

#define EMaskNONE		0
#define EMaskKEY		1
#define EMaskBUTTON1		(1<<1)
#define EMaskBUTTON2		(2<<1)
#define EMaskBUTTON3		(3<<1)
#define EMaskBUTTON4		(4<<1)
#define EMaskBUTTON5		(5<<1)


typedef struct
{
 char*		Name;
 EArgVal	Value;
} EguiArg;

typedef EguiArg*	EguiArgList;


typedef struct _EguiItemRec*	EguiItem;
typedef struct _EguiClassRec*	EguiItemClass;


// Callbacks
//
typedef void	(*EguiCallbackProc)(EguiItem, EPointer, EPointer);

typedef struct EguiCallbackRec
{
 EguiCallbackProc	Proc;
 EPointer		ClientData;
} EguiCallbackRec;

typedef struct EguiCallbackList
{
 int			NumOfCallbacks;
 EguiCallbackRec*	Callbacks;
} EguiCallbackList;



typedef struct
{
 int		Depth;						// Bits per pixel
 unsigned long	RedMask, GreenMask, BlueMask;			// Bitmasks for the color channels
 int		RedShift, GreenShift, BlueShift;		// How much to shift an R, G or B value to get to it's position in the mask
 unsigned long	RedTable[256], GreenTable[256], BlueTable[256];	// Channel lookup-tables

#ifdef EGUIXe
 Colormap	X_Colormap;				// The (default) X11 colormap associated with this Visual
 XVisualInfo*	X_VisualInfo;				// The X11 VisualInfo structure
#endif // EGUIXe

#ifdef WIN32
#endif
} EguiVisual;


typedef struct
{
#ifdef EGUIXe
 XEvent*	X_Event;			// The X11 event
#endif // EGUIXe
} EguiEvent;

// Callback reasons
//
enum
{
 EguiCR_ACTIVATE
};



#define EguiCallbackStructCore()\
 int	Reason

typedef struct
{
 EguiCallbackStructCore();
} EguiAnyCallbackStruct;


typedef struct
{
 EguiCallbackStructCore();

// EguiOptionMenuCallbackStruct part
//
 int	Index, NumOfItems,
	Value;
} EguiOptionMenuCallbackStruct;



// Global variables
//
extern EguiVisual*	EGUI_ColorindexVisuals;
extern int		EGUI_NumOfColorindexVisuals;

extern EguiVisual*	EGUI_TruecolorVisual;		// The truecolor visual with the highest depth
extern EguiVisual*	EGUI_TruecolorVisuals;
extern int		EGUI_NumOfTruecolorVisuals;
extern int		EGUI_TruecolorFormat;


// Public global variables and functions
//
extern int	EGUI_IconXSize, EGUI_IconYSize;


#ifdef EGUIXe
extern Pixmap	EGUI_VaXPMToPixmap(char**, ...);
extern Pixmap	EGUI_VaRGBAToPixmap(unsigned char* LRGBA8Image, int LXSize, int LYSize, ...);
extern Pixmap	EGUI_VaCImageToPixmap(EpCImage* LImage, ...);

extern void	_EGUI_ExposeWidget(Widget LWidget);

extern Pixel	EGUI_XGetRGBiColor(EguiVisual* LVisual, EcRGBiColor* LColor);
extern Pixel	EGUI_XGetRGBfColor(EguiVisual* LVisual, EcRGBfColor* LColor);
extern Pixel	EGUI_XGetRGBfColorShade(EguiVisual* LVisual, EcRGBfColor* LColor, float LIntensity);

extern Pixel	EGUI_XGetRGBAiColor(EguiVisual* LVisual, EcRGBAiColor* LRGBAiColor);

#endif // EGUIXe


extern int	EGUI_Init(int LArgC, String* LArgV, EguiArgList LArgList, int LArgCnt);
extern void	EGUI_Free();
extern int	EGUI_Sync(void (*LEFunct)(EguiEvent*));
extern void	EGUI_MainLoop(void (*LEFunct)(EguiEvent*));
extern void	EGUI_DestroyItem(EguiItem LItem);

extern EBool	EGUI_IsTruecolor();

extern void	EGUI_DestroyItem(EguiItem LItem);

extern void	EGUI_AddCallback(EguiItem LItem, char* LCallbackName, EguiCallbackProc LCallback, EPointer LClientData);
extern void	EGUI_RemoveAllCallback(EguiItem LItem, char* LCallbackName);
extern void	EGUI_CallCallbacks(EguiItem LItem, EguiCallbackList* LCBList, EPointer LCallData);


extern EguiItem	EGUI_CreateScrolledList(char* LName, EguiItem LParent, EguiArgList LArgs, int LArgCnt);


extern Colormap		EGUI_Colormap;
extern XtAppContext	EGUI_AppContext;
extern Display*		EGUI_Display;
extern int		EGUI_ScreenNumber;




#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}  // Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EGUI_h
