/*==============================================================*/
/* EGUI: a platform-independent GUI API				*/
/*								*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1995-Nov-12 23:27:59				*/
/*								*/
/* Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EGUIP_h
#define _EGUIP_h

#include <EGUI/EGUI.h>


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#define		EGUI_ITEM_ALLOCSTEP	16

#ifdef EGUIXe
extern XFontStruct*	EGUI_LabelXFontStruct;
extern XFontStruct*	EGUI_MenuXFontStruct;
extern XFontStruct*	EGUI_ListXFontStruct;
extern XFontStruct*	EGUI_TextXFontStruct;
extern XFontStruct*	EGUI_NumXFontStruct;
extern XeFontList	EGUI_LabelFontList, EGUI_MenuFontList, EGUI_ListFontList, EGUI_TextFontList, EGUI_NumFontList;

#ifdef _XeUSEXm
extern XmFontList	EGUI_LabelXmFontList, EGUI_MenuXmFontList, EGUI_ListXmFontList, EGUI_TextXmFontList, EGUI_NumXmFontList;
#endif // _XeUSEXm

extern XtTranslations	EGUI_TextWidgetTransTable, EGUI_ListTransTable;

extern Atom		EguiIA_STRING, EguiIA_PIXMAP, EguiIA_WM_PROTOCOLS, EguiIA_WM_DELETE_WINDOW;

#endif // EGUIXe



/*======================================*/
/* Core	GUI item			*/
/*======================================*/
#ifndef _ECoreP_h
#define _ECoreP_h

#define E_IDC	0

// Record for registering callbacks in the class record of an EguiItem
//
typedef struct
{
 char*		Name;
 unsigned int	Offset;		// Offset in the item's instance record
#ifdef EGUIXe
 char*		XeName;		// Name of the callback in Xe
#endif // EGUIXe
} ERCallbackRec;

// Class record
//
typedef struct _EguiClassRec
{
 char*		Name;
 unsigned long	InstanceSize;
 void		(*Destroy)(EguiItem);
#ifdef EGUIXe
 void		(*AddChild)(EguiItem, char*, Arg*, Cardinal);
#endif // EGUIXe
 int		NumOfCallbacks;
 ERCallbackRec*	CallbackOffsets;
#ifdef EGUIXe
 XtCallbackProc	XtCBH;		// Callback handler for Xt
#endif // EGUIXe
} EguiClassRec;

// Core instance record
//
typedef struct
{
 char*		Name;
 EguiItem	Parent;
 char*		Location;		// This is for the application to know where to put an item (on a menu, a panel etc.)
 int		ClassID;		// For quick class identification
 EguiClassRec*	Class;
#ifdef EGUIXe
 Widget		WidgetID;
#endif // EGUIXe
 EPointer	UserData;
} EguiCorePart;

typedef struct _EguiItemRec
{
 EguiCorePart	Core;
} EguiItemRec, EguiCoreRec;



#endif // _ECoreP_h


extern EguiItem*	EGUI_Items;
extern int		EGUI_NumOfItems;



/*======================================*/
/* List with optional buttons		*/
/*======================================*/
#ifndef _ListP_h
#define _ListP_h

typedef struct
{
 Widget			FormW, RowColW, ListW;
 EguiCallbackList	SelectionCallback;
} EguiListPart;

typedef struct
{
 EguiCorePart		Core;
 EguiListPart		List;
} EguiListRec;

#endif // _ListP_h


/*======================================*/
/* Separator				*/
/*======================================*/
#ifndef _SeparatorP_h
#define _SeparatorP_h

typedef struct
{
 int	Ez;
} EguiSeparatorPart;

typedef struct
{
 EguiCorePart		Core;
 EguiSeparatorPart	Separator;
} EguiSeparatorRec;

extern EguiItem	EGUI_AddSeparator(char* LLocation, char* LName);

#endif // _SeparatorP_h


/*======================================*/
/* ToggleButton				*/
/*======================================*/
#ifndef _ToggleButtonP_h
#define _ToggleButtonP_h

typedef struct
{
 EguiCallbackProc	Callback;
 EPointer		ClientData;
 char			Mnemonic;
 char*			Accel;
 char*			AccelText;
 char*			ToolTip;
 EguiCallbackList	ValueChangedCallback;
 EBool			State;
} EguiToggleButtonPart;

typedef struct
{
 EguiCorePart		Core;
 EguiToggleButtonPart	ToggleButton;
} EguiToggleButtonRec;

extern EguiItem	EguiAddToggleButton(char* LLocation, EBool LDefault, char* LName, char LMnemonic, char* LAccel, char* LAccelText, EguiCallbackProc LCallback, EPointer LClientData);
extern void	EguiCB_ToggleButton(Widget LW, XtPointer LClientData, XtPointer LCallData);

#endif // _ToggleButtonP_h


/*--------------------------------------*/
/* Fast class identification		*/
/*--------------------------------------*/
enum
{
 EguiNONE=0,
 EguiDIALOG,
 EguiFILESELECTIONBOX,
 EguiCOLOR_DIALOG,
 EguiLIST,
 EguiPUSHBUTTON,
 EguiSEPARATOR,
 EguiSHELL,
 EguiTOGGLEBUTTON
};


extern EguiItem*	EGUI_Items;
extern int		EGUI_NumOfItems, EGUI_MaxNumOfItems;

extern EguiItem		_EGUI_CreateItem(char* LName, EguiItemClass LClass, EguiItem LParent);
extern void		_EGUI_AddItemToList(EguiItem LItem);
extern void		_EGUI_RemoveItemFromList(EguiItem LItem);

#ifdef EGUIXe
extern void		_EGUIXe_GetAttachments(EguiArgList LArgs, int LArgCnt, Arg* LXtArgs, Cardinal* LXtArgCnt);
extern void		_EGUIXt_CallAddChild(EguiItem LItem, char* LName, Arg* Args, Cardinal ArgCnt);



#endif // EGUIXe


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EGUIP_h
