/*======================================================================*/
/* EGUI library 							*/
/*									*/
/* Menu system								*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Oct-17 23:52:16					*/
/*									*/
/* EGUI(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _EMenu_h
#define _EMenu_h


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// EGUI_CreateMenuBar flags
//
#define	EmMENUBAR_SHADOWS	1
#define	EmMENUBAR_VERTICAL	(1<<1)


// EGUI_CreateMenu/EGUI_VaCreateMenu flags
//
#define	EmNORMAL		    0
#define	EmRADIO			0x01	// Menu has RadioBehavior
#define	EmCASCADE_WIDGET	0x01	// Force the menu's CascadeButtons to be CascadeButtonWidget (the default is xmCascadeButtonGadget)
#define	EmSHOW_ARROW		0x02	// Show menu posting direction with an arrow
#define	EmMENUPOST_ON_LEFT	0x08	// Where to post the menu relative to the CascadeButton
#define	EmMENUPOST_ON_RIGHT	0x10
#define	EmMENUPOST_ON_ABOVE	0x20
#define	EmMENUPOST_ON_BELOW	0x40

#define EmMENU_POST_DIRECTION	(EmMENUPOST_ON_LEFT|EmMENUPOST_ON_RIGHT|EmMENUPOST_ON_ABOVE|EmMENUPOST_ON_BELOW)


#define MAX_MENULEVELS		 16

#define	EguiMENUBAR_LEVEL	0


//enum { EmCASTSHADOW_XSHAPE=0, EmCASTSHADOW_SGITRUECOLOR };
//enum { Em_GADGET=0, Em_WIDGET };
//enum { Em_PUSHBUTTON=0, Em_TOGGLEBUTTON };



typedef struct
{
 char*			Name;
 int			Value;
 EguiCallbackProc	Callback;
 EPointer		ClientData;
 EpCImage*		Icon;
} EguiOptionMenuRec;




typedef struct EguiMenuRecS	EguiMenuRec;

typedef struct EguiMenuRootRecS	EguiMenuRootRec;

struct EguiMenuRecS
{
 EguiMenuRootRec*	MenuBar;
 EguiMenuRec*		Parent;
 EguiMenuRec*		Sibling;
 EguiMenuRec*		Child;
 int			CastShadowOffset;
 Widget			CascadeBW, MenuPaneW;
};


struct EguiMenuRootRecS
{
 EguiMenuRec*	Menu;					// The Menu structure representing the MenuBar itself
 Widget		ActiveSubPushB, ActiveSubToggleB;
 int		ActLevel;
 Widget		ActiveCascades[MAX_MENULEVELS];		// The cascadeButton is active but the menu is not necessarily posted
 unsigned int	NumOfPostedMenus;
 EguiMenuRec*	PostedMenus[MAX_MENULEVELS];
 EguiMenuRec*	Menus;					// Hierarchy-linked pointers
 Pixel		BackgroundColor, ForegroundColor, TopShadowColor, BottomShadowColor, SelectColor, ButtonArmColor;
 XeFontList	FontList;
 EBool		MenuBarActive, KeyboardTraversalOn;
 EBool		ActiveSubPushBOnOptionsButton;
};



extern EcRGBAiColor	EGUI_MenuButtonArmRGBAiColor;

extern EguiMenuRec*	EGUI_CreateMenuBar(Widget LParentW, int LFlags, Pixel LBackgroundC, Pixel LForegroundC, Pixel LTopShadowC, Pixel LBottomShadowC, Pixel LSelectC, XeFontList LFontLst);

extern EguiMenuRec*	EGUI_CreatePopupMenu(Widget LParentW, int LFlags, Pixel LBackgroundC, Pixel LForegroundC, Pixel LTopShadowC, Pixel LBottomShadowC, Pixel LSelectC, XeFontList LFontLst);
extern void		EGUI_MenuPopUp(EguiMenuRec* LMenu, int LX, int LY);


extern EguiMenuRec*	EGUI_CreateMenu(EguiMenuRec* LParentMenu, char* LName, char LMnemonic, int LFlags, int LCastShadowOffset);
extern EguiMenuRec*	EGUI_VaCreateMenu(EguiMenuRec* LParentMenu, char* LName, int LFlags, ...);


extern Widget		EGUI_CreateMenuSeparator(EguiMenuRec* LMenu);
extern Widget		EGUI_CreateMenuPushButton(EguiMenuRec* LMenu, char* LName, char LMnemonic, char* LAccelerator, char* LAcceleratorText, EBool LCreateOptionsButton, XtCallbackProc LCallbackID, XtPointer LClientData);
extern Widget		EGUI_CreateMenuToggleButton(EguiMenuRec* LMenu, char* LName, Boolean LDefault, char LMnemonic, char* LAccelerator, char* LAcceleratorText, XtCallbackProc LCallbackID, XtPointer LClientData);

extern Widget		EGUI_CreateMenuLabel(EguiMenuRec* LMenu, char*);
extern Widget		EGUI_CreateMenuBarPushButton(EguiMenuRec* LMenuBar, char* LName, char LMnemonic, char* LAccelerator, char* LAcceleratorText, XtCallbackProc LCallbackID, XtPointer LClientData);
extern Widget		EGUI_VaCreateMenuBarPushButton(EguiMenuRec* LMenuBar, char* LName, char LMnemonic, char* LAccelerator, char* LAcceleratorText, XtCallbackProc LCallbackID, XtPointer LClientData, ...);
extern Widget		EGUI_CreateMenuBarToggleButton(EguiMenuRootRec* LMenuBar, Widget LParentW, char* LName, Boolean LDefault, char LMnemonic, char* LAccelerator, char* LAcceleratorText, XtCallbackProc LCallbackID, XtPointer LClientData);

extern Widget		EGUI_OptionMenuCreate(Widget LParentW, Widget* LMenuWRet, EguiOptionMenuRec* LOptions, int LNumOfItems, int LValue, char* LLabel, EguiCallbackProc LCallback, EPointer LClientData, ArgList LArgs, int LArgCnt);
extern void		EGUI_OptionMenuSetOptionByNumber(Widget LMenuW, int LOptionNumber);
extern void		EGUI_FreeMenuBar(EguiMenuRec* LMenuBar);


extern Widget		EGUI_RealizeCachedMenuItem(EguiMenuRec* LMenu, EguiItem LItem, Widget LBeforeW);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif


#endif // _EMenu_h
