/*======================================================================*/
/* Generic plugin manager						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Jan-10 23:27:53					*/
/*									*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.		*/
/*======================================================================*/

#include <X11/IntrinsicP.h>

#include <Color/XColor.h>

extern Display*	EGUI_Display;

static EguiItem	Egui_PluginManagerDialog=NULL;


static EGUIFolder	_Folders[64];
static unsigned int	_NumOfFolders=0;


static Widget	Egui_PILoadedLW=NULL,
//		Egui_PIAutoLoadLW=NULL,
		Egui_PIInfoLW=NULL,
		E_PluginsSWW=NULL,		// Scrolled-window window widget
		Egui_PluginsTopMatrixW=NULL,
		Egui_PluginsMatrixW=NULL,	// Matrix for plugins with no folder defined
		Egui_PluginInfoLabelW=NULL;



static EguiItem	Egui_PluginInfoDialog=NULL;

typedef struct
{
 EPlugin*	Plugin;
 Widget		LabelW, LoadedBW, AutoLoadBW, InfoBW;
 EBool		Loaded, AutoLoad;
} EPluginM;


static EPluginM*	_InfoPlugin=NULL;		// The plugin with its info shown

static EPluginM**	Egui_AccessiblePluginsM=NULL;
static unsigned int	Egui_MaxNumOfAccessiblePluginsM=0;

static Widget		E_HScrollbar=NULL, E_VScrollbar=NULL;

EcRGBAiColor		EGUI_SliderRGBAiColor = { 0x8000, 0xAC00, 0xBC00, 0xFFFF };




static void		_CB_PluginManagerInfo(Widget LW, XtPointer LClientData, XtPointer LCallData);



/*======================================*/
/* Plugin manager dialog callbacks	*/
/*======================================*/
void EguiCB_PluginManager(EguiItem LI,  EPointer LClientData,  EPointer LCallData)
{
 switch((int)LClientData)
 {
  case EguiOK:
  break;

  case EguiCANCEL:
   EGUI_UndisplayShell(Egui_PluginManagerDialog);
  break;
 }
}


/*======================================*/
/* Init PluginMRec			*/
/*======================================*/
void E3dp_InitPluginMRec(EPluginM* LPluginM)
{
 LPluginM->Plugin=NULL;
 LPluginM->Loaded=FALSE;LPluginM->AutoLoad=FALSE;
 LPluginM->LabelW=NULL;
 LPluginM->LoadedBW=NULL;
 LPluginM->AutoLoadBW=NULL;
}


/*======================================*/
/* Load/Unload plugin			*/
/*======================================*/
void E3dpCB_PluginManagerLoadCh(Widget LW, XtPointer LClientData, XtPointer LCallData)
{
 EPluginM*	LPluginM;
 EPlugin*	LPlugin;

 LPluginM=(EPluginM*)LClientData;

 if(((XeToggleButtonCallbackStruct*)LCallData)->set)
 {
//  E3dp_PrintMessage(0, 2500, "Loading plugin: %s", LPluginM->Plugin->DSOName);
// Load plugin
//
  if(!(LPluginM->Loaded))
  {
   LPlugin=LPluginM->Plugin;
   _LoadPlugin(NULL, 0, (void*)LPlugin, NULL, NULL);

   if(LPlugin->DLHandle==NULL) XeToggleButtonSetState(LW, False, False);
   else
   {
    LPluginM->Plugin->InitFunction(LPluginM->Plugin);
    LPluginM->Loaded=TRUE;
//    E3dp_PrintMessage(0, 2500, "Loaded plugin: %s", LPluginM->Plugin->DSOName);
   }

// If the info for this plugin is being shown, update it
//
   if(_InfoPlugin==LPluginM) _CB_PluginManagerInfo(NULL, (XtPointer)LPluginM, NULL);
  }
 }
 else
 {
// Unload plugin
//
  if(LPluginM->Loaded)
  {
   LPlugin=LPluginM->Plugin;

   if(LPlugin->LockCount>0)
   {
    E_PrintMessage(0, 10000, "Plugin \"%s\" is in use, it would be unsafe to unload it. Hint: check if the plugin has any dialog-boxes open!", LPluginM->Plugin->Name);
    XeToggleButtonSetState(LW, True, False);
    return;
   }

   E_PluginUnload(LPlugin);


   LPluginM->Loaded=FALSE;
//printf("[%s] Unloaded\n", LPluginM->Plugin->DSOName);fflush(stdout);

// If the info for this plugin is being shown, update it
//
   if(_InfoPlugin==LPluginM) _CB_PluginManagerInfo(NULL, (XtPointer)LPluginM, NULL);
  }
 }
}


/*======================================*/
/* Turn autoload on/off plugin		*/
/*======================================*/
void E3dpCB_PluginManagerAutoLoadCh(Widget LW, XtPointer LClientData, XtPointer LCallData)
{
 EPluginM*		LPluginM;

 LPluginM=(EPluginM*)LClientData;
}


/*======================================*/
/* Plugin info dialog callback		*/
/*======================================*/
void EguiCB_PluginInfo(EguiItem LI, EPointer LClientData, EPointer LCallData)
{
 switch((int)LClientData)
 {
  case EguiCANCEL:
   EGUI_UndisplayShell(Egui_PluginInfoDialog);
   _InfoPlugin=NULL;
  break;
 }
}


/*======================================*/
/* Plugin info button callback		*/
/*======================================*/
static void _CB_PluginManagerInfo(Widget LW, XtPointer LClientData, XtPointer LCallData)
{
 EPluginM*	LPluginM;
 EPlugin*	LPlugin;
 EguiArg	LArgs[32];
 int		LArgCnt;
 EguiItem	LI;
 EguiDialogRec*	LD;
 Widget		LTopMatrixW;
 XeString	LXeStr;
 char*		LStatusColor;
 char		LTmpStr[4096];
 char		LStatusString[4096];

 LPluginM=(EPluginM*)LClientData;
 LPlugin=LPluginM->Plugin;

 LStatusString[0]='\0';
 if(LPluginM->Loaded) { strcpy(LStatusString, " Successfully loaded");LStatusColor="dark green"; }
 else
 {
  if(LPlugin->ErrorMessage==NULL) { strcpy(LStatusString, " Not loaded / unloaded by user");LStatusColor="dim grey"; }
  else { sprintf(LStatusString, " Falied to load. Reason:\n %s\n", LPlugin->ErrorMessage);LStatusColor="dark red"; }
 }

 sprintf(LTmpStr, "/%s.so\n\nStatus:\n%s\n\nUser interface:\n", LPlugin->DSOName, LStatusString);
 LXeStr=XeStringVaCreate(True, XeSTRING_COMPONENT_CHARSET, "tag1", XeSTRING_COMPONENT_ALIGN, XeSTRING_ALIGN_LEFT,
                         XeSTRING_COMPONENT_TEXT, "Name:\n ",
                         XeSTRING_COMPONENT_COLOR_NAME, "blue", XeSTRING_COMPONENT_TEXT, LPlugin->Name,
                         XeSTRING_COMPONENT_COLOR_NAME, "black", XeSTRING_COMPONENT_TEXT, "\n\nPlugin object file:\n ", XeSTRING_COMPONENT_COLOR_NAME, "blue", XeSTRING_COMPONENT_TEXT, LPlugin->PathName, XeSTRING_COMPONENT_TEXT, "/", XeSTRING_COMPONENT_TEXT, LPlugin->DSOName, XeSTRING_COMPONENT_TEXT, ".so",
                         XeSTRING_COMPONENT_COLOR_NAME, "black", XeSTRING_COMPONENT_TEXT, "\n\nStatus:\n", XeSTRING_COMPONENT_COLOR_NAME, LStatusColor, XeSTRING_COMPONENT_TEXT, LStatusString,
			 XeSTRING_COMPONENT_UNKNOWN);

 if(Egui_PluginInfoDialog==NULL)
 {
  LArgCnt=0;
  EguiSetArg(EguiNallowShellResize, True, LArgs, LArgCnt);
  EguiSetArg(EguiNwmDecorations, EguiWM_DECOR_BORDER|EguiWM_DECOR_RESIZEH|EguiWM_DECOR_TITLE|EguiWM_DECOR_MINIMIZE, LArgs, LArgCnt);
  EguiSetArg(EguiNstretchButtons, False, LArgs, LArgCnt);
  EguiSetArg(EguiNtitle, "Plugin info", LArgs, LArgCnt);EguiSetArg(EguiNiconName, "Plugin info", LArgs, LArgCnt);
  EguiSetArg(EguiNseparatorType, EguiSINGLE_LINE_TOP, LArgs, LArgCnt);
  EguiSetArg(EguiNcustomItemType, EguiMATRIX, LArgs, LArgCnt);
  if((Egui_PluginInfoDialog=EGUI_CreateDialog(EguiDIALOG_TEMPLATE, "Plugin info", E_TopShell, LArgs, LArgCnt))==NULL) return;

  LD=(EguiDialogRec*)Egui_PluginInfoDialog;

  LArgCnt=0;
  EguiSetArg(EguiNshowAsDefault, True, LArgs, LArgCnt);
  LI=EGUI_CreatePushButton("Close", Egui_PluginInfoDialog, LArgs, LArgCnt);
  EGUI_AddCallback(LI, EguiNactivateCallback, EguiCB_PluginInfo, (EPointer)EguiCANCEL);


  LTopMatrixW=EGUI_DialogGetChild(Egui_PluginInfoDialog, EguiDIALOG_WORK_AREA);

  EXtStart;
  EXtSetArg(XeNmarginWidth, 4);EXtSetArg(XeNmarginHeight, 4);
  XtSetValues(LTopMatrixW, Args, ArgCnt);

  EXtStart;
//  EXtSetArg(XeNshadowThickness, 1);EXtSetArg(XeNshadowType, XeSHADOW_IN);
  EXtSetArg(XeNmarginWidth, 7);EXtSetArg(XeNmarginHeight, 7);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);

  if(LXeStr) { EXtSetArg(XeNlabelString, LXeStr); }
  Egui_PluginInfoLabelW=XtCreateManagedWidget("", xeLabelWidgetClass, LTopMatrixW, Args, ArgCnt);
 }
 else
 {
  if(LXeStr)
  {
   EXtSetArg(XeNlabelString, LXeStr);
   XtSetValues(Egui_PluginInfoLabelW, Args, ArgCnt);
  }
 }

 _InfoPlugin=LPluginM;

 if(LXeStr) XeStringFree(LXeStr);
 EGUI_RaiseShell(Egui_PluginInfoDialog);
}


/*======================================*/
/* Refresh Plugin manager GUI		*/
/*======================================*/
void E3dp_RefreshPluginList()
{
 Widget		LMatrixW, LTAW;
 unsigned int	LC, LNumOfAccessiblePlugins;
 EPluginM**	LAccessiblePlugins;
 EPluginM*	LAccessiblePlugin;
 EPlugin*	LPlugin;
 Dimension	LXSize, LMargTop, LMargBott;
 int		LScrollIncrement;

 if((LNumOfAccessiblePlugins=E_NumOfPlugins)==0) return;
 if(Egui_AccessiblePluginsM==NULL)
 {
  if((Egui_AccessiblePluginsM=(EPluginM**)EMalloc(sizeof(EPluginM*)*LNumOfAccessiblePlugins))==NULL) return;
  Egui_MaxNumOfAccessiblePluginsM=LNumOfAccessiblePlugins;
  LAccessiblePlugins=Egui_AccessiblePluginsM;
  for(LC=0;LC<LNumOfAccessiblePlugins;LC++)
  {
   if((LAccessiblePlugins[LC]=LAccessiblePlugin=(EPluginM*)EMalloc(sizeof(EPluginM)))!=NULL) E3dp_InitPluginMRec(LAccessiblePlugin);
  }
 }

 if(LNumOfAccessiblePlugins>Egui_MaxNumOfAccessiblePluginsM)
 {
  if((LAccessiblePlugins=(EPluginM**)ERealloc(Egui_AccessiblePluginsM, sizeof(EPluginM*)*LNumOfAccessiblePlugins))!=NULL)
  {
   Egui_AccessiblePluginsM=LAccessiblePlugins;

   for(LC=Egui_MaxNumOfAccessiblePluginsM;LC<LNumOfAccessiblePlugins;LC++)
   {
    if((LAccessiblePlugins[LC]=LAccessiblePlugin=(EPluginM*)EMalloc(sizeof(EPluginM)))!=NULL) E3dp_InitPluginMRec(LAccessiblePlugin);
   }
   Egui_MaxNumOfAccessiblePluginsM=LNumOfAccessiblePlugins;
  }
 }

 if((LAccessiblePlugins=Egui_AccessiblePluginsM)!=NULL)
 {
  if(E_NumOfPlugins<=Egui_MaxNumOfAccessiblePluginsM)		// Get the loaded plugins first
  {
   EguiVisual*		LVisual=EGUI_TruecolorVisual;
   EGUIFolder*	LFolder;
   unsigned int		LFC;
   char			LFolderName[64];

   for(LC=0, LTAW=NULL, LMargTop=0, LMargBott=0;LC<E_NumOfPlugins;LC++)
   {
    LAccessiblePlugin=LAccessiblePlugins[LC];

    LPlugin=E_Plugins+LC;
    LAccessiblePlugin->Plugin=LPlugin;

    if(LPlugin->DLHandle!=NULL) LAccessiblePlugin->Loaded=TRUE;
    else LAccessiblePlugin->Loaded=FALSE;

    if(LAccessiblePlugin->LabelW==NULL)
    {
     LMatrixW=Egui_PluginsMatrixW;

// Check if the plugin name has a folder defined (folder/name format)
//
     if(EStr_GetPathName(LAccessiblePlugin->Plugin->Name, LFolderName, 64))
     {
      LFolderName[strlen(LFolderName)-1]='\0';

      LFolder=_Folders;
      for(LFC=0;LFC<_NumOfFolders;LFC++, LFolder++)
      {
       if(EStr_StringsEqual(LFolder->Name, LFolderName)) { LMatrixW=LFolder->FolderW;break; }
      }
      if(LFC==_NumOfFolders)
      {
       if(_NumOfFolders<64)
       {
        LFolder=_Folders+LFC;

	strcpy(LFolder->Name, LFolderName);

	EXtStart;
	EXtSetArg(XeNmarginWidth, 2);EXtSetArg(XeNmarginTop, 5);EXtSetArg(XeNmarginBottom, 0);
	EXtSetArg(XeNmarginHeight, 0);
	EXtSetArg(XeNshadowThickness, 0);
	EXtSetArg(XeNfontList, EGUI_LabelFontList);
	EXtSetArg(XeNlabelXAlignment, XeALIGN_BEGINNING);
	EXtSetArg(XeNlabelType, XePIXMAP_STRING_HORIZONTAL);

	if(LVisual)
	{
	EXtSetArg(XeNbackground, EGUI_TCBackgroundColor);
	EXtSetArg(XeNactiveColor, EGUI_TCBackgroundColor);
	EXtSetArg(XeNarmColor, EGUI_TCBackgroundColor);
	 EXtSetArg(XeNvisualInfo, LVisual->X_VisualInfo);EXtSetArg(XeNcolormap, LVisual->X_Colormap);
	 EXtSetArg(XeNlabelPixmap, EGUI_RArrowPixmap);
	 EXtSetArg(XeNactivePixmap, EGUI_RArrowHPixmap);
	}
	else
	{
	 EXtSetArg(XeNbackground, EGUI_BackgroundColor);
	 EXtSetArg(XeNactiveColor, EGUI_BackgroundColor);
	 EXtSetArg(XeNarmColor, EGUI_BackgroundColor);
	}

	LFolder->ButtonW=XtCreateManagedWidget(LFolderName, xePushButtonWidgetClass, Egui_PluginsTopMatrixW, Args, ArgCnt);
	XtAddCallback(LFolder->ButtonW, XeNactivateCallback, (XtCallbackProc)_EGUICB_FolderOpenClose, (XtPointer)LFolder);

	{
	 char	LTmpStr[256];

	 sprintf(LTmpStr, "PluginMatrixW-%s", LFolderName);
	 EXtStart;
	 EXtSetArg(XeNmarginWidth, 16);EXtSetArg(XeNmarginHeight, 0);
	 EXtSetArg(XeNxSpacing, 10);EXtSetArg(XeNySpacing, 1);
	 EXtSetArg(XeNshadowThickness, 0);
	 EXtSetArg(XeNorientation, XeHORIZONTAL);
	 EXtSetArg(XeNnumOfColumns, 3);
	 EXtSetArg(XeNbackground, EGUI_BackgroundColor);
	 LFolder->FolderW=LMatrixW=XtCreateWidget(LTmpStr, xeMatrixWidgetClass, Egui_PluginsTopMatrixW, Args, ArgCnt);
	}

	_NumOfFolders+=1;
       }
      }
     }

     EStr_GetFileName(LAccessiblePlugin->Plugin->Name, LFolderName, 64);

     EXtStart;
     EXtSetArg(XeNmarginTop, LMargTop);EXtSetArg(XeNmarginBottom, LMargBott);
     EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);
     EXtSetArg(XeNlabelXAlignment, XeALIGN_BEGINNING);
     EXtSetArg(XeNbackground, EGUI_BackgroundColor);
     EXtSetArg(XeNforeground, EGUI_ForegroundColor);
     EXtSetArg(XeNfontList, EGUI_LabelFontList);
     LAccessiblePlugin->LabelW=XtCreateManagedWidget(LFolderName, xeLabelWidgetClass, LMatrixW, Args, ArgCnt);

// "Loaded" button
//
     EXtStart;
     EXtSetArg(XeNbackground, EGUI_BackgroundColor);
     EXtSetArg(XeNselectColor, EGUI_HighlightColor);
     EXtSetArg(XeNset, LAccessiblePlugin->Loaded);
     EXtSetArg(XeNindicatorSize, 14);
     EXtSetArg(XeNwidthAdjustable, False);
     LAccessiblePlugin->LoadedBW=XtCreateManagedWidget("", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
     XtAddCallback(LAccessiblePlugin->LoadedBW, XeNvalueChangedCallback, (XtCallbackProc)E3dpCB_PluginManagerLoadCh, (XtPointer)LAccessiblePlugin);

/*
// "Auto-load" button
//
     EXtStart;
     if(LYSizeB!=0) EXtSetArg(XeNheight, LYSizeB);
     EXtSetArg(XeNbackground, EGUI_BackgroundColor);
     EXtSetArg(XeNselectColor, EGUI_HighlightColor);
     EXtSetArg(XeNset, LAccessiblePlugin->AutoLoad);
     EXtSetArg(XeNwidhtAdjustable, False);
     LAccessiblePlugin->AutoLoadBW=XtCreateManagedWidget("", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
     XtAddCallback(LAccessiblePlugin->AutoLoadBW, XeNvalueChangedCallback, (XtCallbackProc)E3dpCB_PluginManagerAutoLoadCh, (XtPointer)LAccessiblePlugin);
*/

// "Info" button
//
     EXtStart;
     EXtSetArg(XeNmarginWidth, 4);EXtSetArg(XeNmarginHeight, 0);
     EXtSetArg(XeNbackground, EGUI_ButtonColor);
     EXtSetArg(XeNfontList, EGUI_LabelFontList);
     EXtSetArg(XeNwidthAdjustable, False);
     LAccessiblePlugin->InfoBW=XtCreateManagedWidget("i", xePushButtonWidgetClass, LMatrixW, Args, ArgCnt);
     XtAddCallback(LAccessiblePlugin->InfoBW, XeNactivateCallback, (XtCallbackProc)_CB_PluginManagerInfo, (XtPointer)LAccessiblePlugin);
    }
   }
  }
 }
 LXSize=XeMatrixColumnWidth(Egui_PluginsMatrixW, 0);
 XtVaSetValues(Egui_PILoadedLW, XeNleftOffset, LXSize+2, NULL);
 LXSize+=XeMatrixColumnWidth(Egui_PluginsMatrixW, 1);
 XtVaSetValues(Egui_PIInfoLW, XeNleftOffset, LXSize+25, NULL);
 LScrollIncrement=XeMatrixRowHeight(Egui_PluginsMatrixW, 0);

 XtVaSetValues(E_VScrollbar, XeNincrement, LScrollIncrement+2, XeNsmoothScrollSteps, 8, NULL);	// XeNySpacing = 2 on XeMatrix

// XtVaSetValues(Egui_PIAutoLoadLW, XeNleftOffset, LXSize+5, NULL);
}


/*======================================*/
/* Plugin manager			*/
/*======================================*/
void Egui_PopUpPluginManager(char* LDialogTitle)
{
 EguiDialogRec*	LD;
 Widget		LTopMatrixW, LMatrixW, LLabelW;
 EguiArg	LArgs[32];
 int		LArgCnt;
 EguiItem	LI;
 Dimension	LXSize;

 if(Egui_PluginManagerDialog==NULL)
 {
  LArgCnt=0;
  EguiSetArg(EguiNallowShellResize, True, LArgs, LArgCnt);
  EguiSetArg(EguiNstretchButtons, False, LArgs, LArgCnt);
  EguiSetArg(EguiNworkAreaType, EguiMATRIX, LArgs, LArgCnt);
  EguiSetArg(EguiNwmDecorations, EguiWM_DECOR_BORDER|EguiWM_DECOR_RESIZEH|EguiWM_DECOR_TITLE|EguiWM_DECOR_MINIMIZE, LArgs, LArgCnt);
  EguiSetArg(EguiNtitle, LDialogTitle, LArgs, LArgCnt);EguiSetArg(EguiNiconName, "Plugins", LArgs, LArgCnt);
  EguiSetArg(EguiNseparatorType, EguiSINGLE_LINE_TOP, LArgs, LArgCnt);
  if((Egui_PluginManagerDialog=EGUI_CreateDialog(EguiDIALOG_TEMPLATE, LDialogTitle, E_TopShell, LArgs, LArgCnt))==NULL) return;

  LD=(EguiDialogRec*)Egui_PluginManagerDialog;

//  EGUI_CreatePushButton("Browse", Egui_PluginManagerDialog, NULL, 0);

  LArgCnt=0;
  EguiSetArg(EguiNshowAsDefault, True, LArgs, LArgCnt);
  LI=EGUI_CreatePushButton("Close", Egui_PluginManagerDialog, LArgs, LArgCnt);
  EGUI_AddCallback(LI, EguiNactivateCallback, EguiCB_PluginManager, (EPointer)EguiCANCEL);


  LTopMatrixW=EGUI_DialogGetChild(Egui_PluginManagerDialog, EguiDIALOG_WORK_AREA);
  EXtStart;
  EXtSetArg(XeNorientation, XeVERTICAL);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNySpacing, 3);
  XtSetValues(LTopMatrixW, Args, ArgCnt);


  EXtStart;
  EXtSetArg(XeNxSpacing, 4);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNorientation, XeHORIZONTAL);
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNheightAdjustable, False);
  LMatrixW=XtCreateManagedWidget("", xeMatrixWidgetClass, LTopMatrixW, Args, ArgCnt);


  EXtStart;
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  LLabelW=XtCreateManagedWidget("Name", xeLabelWidgetClass, LMatrixW, Args, ArgCnt);

  EXtStart;
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  Egui_PILoadedLW=XtCreateManagedWidget("Loaded", xeLabelWidgetClass, LMatrixW, Args, ArgCnt);
  XtVaGetValues(Egui_PILoadedLW, XeNwidth, &LXSize, NULL);

/*
  EXtStart;
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  Egui_PIAutoLoadLW=XtCreateManagedWidget("Auto load", xeLabelWidgetClass, LMatrixW, Args, ArgCnt);
*/

  EXtStart;
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  Egui_PIInfoLW=XtCreateManagedWidget("Info", xeLabelWidgetClass, LMatrixW, Args, ArgCnt);


  EXtStart;
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNshadowThickness, 0);EXtSetArg(XeNshadowType, XeSHADOW_IN);
  EXtSetArg(XeNworkAreaShadowThickness, 2);
  EXtSetArg(XeNscrollingPolicy, XeAUTOMATIC);
  EXtSetArg(XeNscrollBarDisplayPolicy, XeAS_NEEDED);
  EXtSetArg(XeNspacing, 4);
  E_PluginsSWW=XeCreateScrolledWindow(LTopMatrixW, "PluginsScrW", Args, ArgCnt);


  EXtStart;
  EXtSetArg(XeNmarginWidth, 4);EXtSetArg(XeNmarginHeight, 2);
  EXtSetArg(XeNxSpacing, 10);EXtSetArg(XeNySpacing, 2);
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNorientation, XeVERTICAL);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  Egui_PluginsTopMatrixW=XtCreateManagedWidget("PluginTopMatrixW", xeMatrixWidgetClass, E_PluginsSWW, Args, ArgCnt);

  EXtStart;
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNxSpacing, 10);EXtSetArg(XeNySpacing, 2);
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);
  EXtSetArg(XeNnumOfColumns, 3);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  Egui_PluginsMatrixW=XtCreateManagedWidget("PluginMatrixW", xeMatrixWidgetClass, Egui_PluginsTopMatrixW, Args, ArgCnt);

  XeScrolledWindowSetAreas(E_PluginsSWW, NULL, NULL, Egui_PluginsMatrixW);

  XtVaGetValues(XtParent(E_PluginsSWW), XeNhorizontalScrollBar, &E_HScrollbar, XeNverticalScrollBar, &E_VScrollbar, NULL);

//  XeGetColorShade(EGUI_Display, E_VScrollbar->core.colormap, , XeTopShadow2Factor);

  XtVaSetValues(E_HScrollbar, XeNsliderBorderWidth, 1, XeNsliderBorderColor, EGUI_ForegroundColor, NULL);
  XtVaSetValues(E_VScrollbar, XeNsliderBorderWidth, 1, XeNsliderBorderColor, EGUI_ForegroundColor, NULL);

//  XtVaSetValues(E_HScrollbar, XeNsliderBorderWidth, 1, XeNsliderBorderColor, EGUI_ForegroundColor, XeNsliderColor, EGUI_ButtonColor, NULL);

//  XtVaSetValues(E_HScrollbar, XeNsliderColor, Ec_XGetRGBAiColor(EGUI_Display, E_VScrollbar->core.colormap, &EGUI_SliderRGBAiColor), NULL);

  XtManageChild(XtParent(E_PluginsSWW));
  EGUI_RaiseShell(Egui_PluginManagerDialog);
  E3dp_RefreshPluginList();
 }
 else
 {
  EGUI_RaiseShell(Egui_PluginManagerDialog);
  E3dp_RefreshPluginList();
 }
}
