/*==============================================================*/
/* EGUI: a platform-independent GUI API				*/
/*								*/
/* EGUIPushButton: private header file				*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1995-Nov-17 21:57:05				*/
/*								*/
/* Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EGUIPushButtonP_h
#define _EGUIPushButtonP_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#include <EGUI/EGUIP.h>
#include <EGUI/PushButton.h>


typedef struct
{
 EguiCallbackList	ActivateCallback;
 EguiCallbackProc	Callback;		// FIXME For BEd only temporarily
 EPointer		ClientData;		//
 char			Mnemonic;
 char*			Accel;
 char*			AccelText;
 char*			ToolTip;
 EpImage*		LabelImage;		// Normal Image
 EpImage*		ActiveImage;		// Image used when the (mouse) pointer is above the PushButton
 EpImage*		ArmImage;		// Image used when the PushButton is armed
 EBool			CreateOptionsButton;	// For PushButtons in menus. A little button on the right for options related to the function
} EguiPushButtonPart;

/*----------------------*/
/* Instance record	*/
/*----------------------*/
typedef struct
{
 EguiCorePart		Core;
 EguiPushButtonPart	PushButton;
} EguiPushButtonRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}  // Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EGUIPushButtonP_h
