/*==============================================================================*/
/* Platform independent input-handler						*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	1998-May-29 22:55:48						*/
/*										*/
/* EInput library Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================================*/
#ifndef _EInput_h
#define _EInput_h

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#include <EParam.h>

#define EX11

#ifdef EX11
#define XK_MISCELLANY
#include <X11/keysymdef.h>
#include <X11/Intrinsic.h>
#endif // EX11


// Key event priorities
//
enum
{
 EKeyPRIORITY_LOW=0,
 EKeyPRIORITY_INTERNAL,
};


enum
{
 EKeyOK=0,
 EKeyError
};

// Key events
//
enum
{
 EKeyPRESS=1,
 EKeyRELEASE,
 EKeyOVERRIDE		// Hot-key was overwritten by an application-internal function
};

#ifdef EX11
//#define EKeyF1		XK_F1
#define EKeyF1		XK_Help
#define EKeyF2		XK_F2
#define EKeyF3		XK_F3
#define EKeyF4		XK_F4
#define EKeyF5		XK_F5
#define EKeyF6		XK_F6
#define EKeyF7		XK_F7
#define EKeyF8		XK_F8
#define EKeyF9		XK_F9
#define EKeyF10		XK_F10
#define EKeyF11		XK_F11
#define EKeyF12		XK_F12

#define EKeyBACKSPACE	XK_BackSpace		// Back space, back char
#define EKeyTAB		XK_Tab
#define EKeyLINEFEED	XK_Linefeed		// Linefeed, LF
#define EKeyCLEAR	XK_Clear
#define EKeyRETURN	XK_Return		// Return, enter
#define EKeyPAUSE	XK_Pause		// Pause, hold
#define EKeySCROLL_LOCK	XK_Scroll_Lock
#define EKeySYS_REQ	XK_Sys_Req
#define EKeyESCAPE	XK_Escape
#define EKeyINSERT	XK_Insert
#define EKeyDELETE	XK_Delete		// Delete, rubout

#define EKeyHOME	XK_Home
#define EKeyLEFT	XK_Left			// Move left, left arrow
#define EKeyUP		XK_Up			// Move up, up arrow
#define EKeyRIGHT	XK_Right		// Move right, right arrow
#define EKeyDOWN	XK_Down			// Move down, down arrow
#define EKeyPRIOR	XK_Prior		// Prior, previous
#define EKeyPAGE_UP	XK_Page_Up
#define EKeyNEXT	XK_Next			// Next
#define EKeyPAGE_DOWN	XK_Page_Down
#define EKeyEND		XK_End			// EOL
#define EKeyBEGIN	XK_Begin		// BOL

// Misc Functions
//
#define EKeyNUM_LOCK	XK_Num_Lock
#define EKeyMENU	XK_Menu


#define EKeySHIFT_L	XK_Shift_L	// Left shift
#define EKeySHIFT_R	XK_Shift_R	// Right shift
#define EKeyCONTROL_L	XK_Control_L	// Left control
#define EKeyCONTROL_R	XK_Control_R	// Right control
#define EKeyCAPS_LOCK	XK_Caps_Lock	// Caps lock
#define EKeySHIFT_LOCK	XK_Shift_Lock	// Shift lock

#define EKeyMETA_L	XK_Meta_L	// Left meta
#define EKeyMETA_R	XK_Meta_R	// Right meta
#define EKeyALT_L	XK_Alt_L	// Left alt
#define EKeyALT_R	XK_Alt_R	// Right alt
#define EKeySuper_L	XK_Super_L	// Left super
#define EKeySuper_R	XK_Super_R	// Right super
#define EKeyHyper_L	XK_Hyper_L	// Left hyper
#define EKeyHyper_R	XK_Hyper_R	// Right hyper



// Keypad Functions, keypad numbers cleverly chosen to map to ascii
//

/*
#define EKeyXK_KP_Space		0xFF80	// space
#define EKeyXK_KP_Tab		0xFF89
#define EKeyXK_KP_Enter		0xFF8D	// enter
#define EKeyXK_KP_F1		0xFF91	// PF1, KP_A, ...
#define EKeyXK_KP_F2		0xFF92
#define EKeyXK_KP_F3		0xFF93
#define EKeyXK_KP_F4		0xFF94
#define EKeyXK_KP_Home		0xFF95
*/
#define EKeyKP_LEFT		XK_KP_Left
#define EKeyKP_UP		XK_KP_Up
#define EKeyKP_RIGHT		XK_KP_Right
#define EKeyKP_DOWN		XK_KP_Down
#define EKeyKP_PRIOR		XK_KP_Prior
#define EKeyKP_PAGE_UP		XK_KP_Page_Up
#define EKeyKP_NEXT		XK_KP_Next
#define EKeyKP_PAGE_DOWN	XK_KP_Page_Down
#define EKeyKP_END		XK_KP_End
#define EKeyKP_BEGIN		XK_KP_Begin
#define EKeyKP_INSERT		XK_KP_Insert
#define EKeyKP_DELETE		XK_KP_Delete
#define EKeyKP_EQUAL		XK_KP_Equal
#define EKeyKP_MULTIPLY		XK_KP_Multiply
#define EKeyKP_ADD		XK_KP_Add
#define EKeyKP_SEPARATOR	XK_KP_Separator
#define EKeyKP_SUBTRACT		XK_KP_Subtract
#define EKeyKP_DECIMAL		XK_KP_Decimal
#define EKeyKP_DIVIDE		XK_KP_Divide

#define EKeyKP_0		XK_KP_0
#define EKeyKP_1		XK_KP_1
#define EKeyKP_2		XK_KP_2
#define EKeyKP_3		XK_KP_3
#define EKeyKP_4		XK_KP_4
#define EKeyKP_5		XK_KP_5
#define EKeyKP_6		XK_KP_6
#define EKeyKP_7		XK_KP_7
#define EKeyKP_8		XK_KP_8
#define EKeyKP_9		XK_KP_9





#endif // EX11


#define EShiftMask	(1<<0)
#define ELockMask	(1<<1)
#define EControlMask	(1<<2)
#define EMod1Mask	(1<<3)
#define EMod2Mask	(1<<4)
#define EMod3Mask	(1<<5)
#define EMod4Mask	(1<<6)
#define EMod5Mask	(1<<7)
#define EButton1Mask	(1<<8)
#define EButton2Mask	(1<<9)
#define EButton3Mask	(1<<10)
#define EButton4Mask	(1<<11)
#define EButton5Mask	(1<<12)

#define EAltMask	EMod1Mask

// Callbacks
//
typedef void	(*EKeyCallbackProc)(unsigned short LKey, unsigned int LModifiers, int LKeyEventType, EPointer LClientData);


#ifdef EX11
extern EBool	E_XProcessKey(KeySym LKeySym, Modifiers LModifiers, int LKeyEventType);
#endif // EX11

extern EBool	E_KeySetCallback(char* LName, unsigned short LKey, unsigned int LModifiers, int LKeyEventType, EKeyCallbackProc LCallback, EPointer LClientData);
extern EBool	E_KeySetInternalCallback(char* LName, unsigned short LKey, unsigned int LModifiers, int LKeyEventType, EKeyCallbackProc LCallback, EPointer LClientData);

extern EBool	E_KeyRemoveCallback(unsigned short LKey, unsigned int LModifiers, int LKeyEventType, EKeyCallbackProc LCallback, EPointer LClientData);

extern void	E_PrintKeyTable();


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}  // Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EInput_h
