/*==============================================================*/
/* E library							*/
/*								*/
/* - Memory management and memory-tracker			*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Dec-09 23:21:39				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EMalloc_h
#define _EMalloc_h

#include <sys/types.h>
#include <string.h>

#include <ETypes.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

//#define E_MEMDEBUG	1	// Do memory profiling

#ifdef E_MEMDEBUG
extern char*	E_MemName;
extern EBool	E_MemVerbose;


#define	EMemALLOC_INCREMENT	4096	// For E_MemBlocks

typedef struct
{
 char		Name[256];
 unsigned long	Size;
 void*		Address;
 EBool		Active;
} EMemEntry;

extern unsigned int	E_NumOfMemBlocks, E_NumOfMemBlocksAllocated;
extern EMemEntry*	E_MemBlocks;
extern void*		E_MemBlock;

extern void	EPrintUnfreedMemory();

#endif // E_MEMDEBUG



extern void*	EMalloc(size_t LSize);
extern void*	ERealloc(void* LBlock, size_t LSize);
extern void	EFree(void* LBlock);
extern char*	EStrDup(char* LStr);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EMalloc_h
