/*==============================================================*/
/* Default parameters header file				*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1995-Nov-11 15:01:00				*/
/*								*/
/* Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EParam_h
#define _EParam_h

#include <ETypes.h>

// Macro to get offset of a field in a structure
//
#if defined(CRAY) || defined(__arm) || defined(__ACK)
#if __STDC__ && !defined(__ACK)
#define EOffset(p_type,field) _Offsetof(p_type,field)
#else
#ifdef CRAY2
#define EOffset(p_type,field) \
	(sizeof(int)*((unsigned int)&(((p_type)NULL)->field)))

#else	/* !CRAY2 */

#define EOffset(p_type,field) ((unsigned int)&(((p_type)NULL)->field))

#endif	/* !CRAY2 */
#endif  /* __STDC__ */
#else	/* ! (CRAY || __arm || __ACK) */

#define EOffset(p_type, field) ((Cardinal) (((char*)(&(((p_type)NULL)->field))) - ((char*)NULL)))

#endif /* !CRAY */

#ifdef offsetof
#define EOffsetOf(s_type,field) offsetof(s_type,field)
#else
#define EOffsetOf(s_type,field) EOffset(s_type*,field)
#endif


// Macro to get offset of a field in a structure as a pointer
//
#define EPtrOffset(p_type, field)	(&(((p_type*)NULL)->field))




#ifdef WIN32
#define ESLASH	'\\'
#define MAXPATHLEN	256
typedef short	nlink_t;

#ifdef LCCC
typedef short	uid_t;
typedef short	gid_t;
typedef long	mode_t;
#endif // LCCC
//typedef long	time_t;
#endif // WIN32

#ifdef UNIX
#define ESLASH	'/'
#include <sys/param.h>
#endif



#endif // _EParam_h
