/*==============================================================*/
/* EPrefs (preferences) I/O					*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jun-28 23:39:09				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EPrefs_h
#define _EPrefs_h

#include <ETypes.h>
#include <EResource.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#define EResMAX_CMDLENGTH	256
#define EResMAX_VALLENGTH	8192


/* EResFLEXIBLE:
void*'s which control string and variable pointers
types in the control string:
'C'	unsigned char
'c'	char
'I'	unsigned int
'i'	int
'S'	unsigned short
's'	short
'L'	unsigned long
'l'	long
'f'	float
'd'	double
's'	char* (string)
*/




typedef struct
{
 int	Value;
 char*	Name;
} ESet;


extern EBool	ERes_ReadASCII(char* LFileName, EResource* LSettingTable);
extern EBool	ERes_SaveASCII(char* LFileName, char* LHeaderString, EResource* LResources);



enum
{
 ESetSUCCESS=0,
 ESetDUPLICATE_NAME,
 ESetFILE_OPEN_ERROR,
 ESetALLOC_ERROR,
 ESetNO_MORE_SPACE,
 ESetERROR,
 ESetNO_SETS,
 ESetFATAL_ERROR
};

extern int	ESet_ReadSets(char* LPath, char* LFileName, int (*LItemInitFunc)(void*, void*), int (*LItemEndFunc)(void*, unsigned int, void*, char*, void*), int (*LGetItemValuesFunc)(void*, void*, char*, char*), unsigned int LItemSize, unsigned int LAllocIncrement, void* LTmpData, void** LItemsRet, unsigned int* LNumOfItemsRet, unsigned int* LNumOfItemsAllocatedRet);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EPrefs_h
