/*==============================================================*/
/* E library							*/
/*								*/
/* - String extension functions					*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-01 23:32:37				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _EStrings_h
#define _EStrings_h

#include <sys/types.h>
#include <string.h>

#include <ETypes.h>

//#include <EMalloc.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



// Entry types in a log file
//
enum
{
 EStrLOG_ERROR=0,
 EStrLOG_WARNING,
 EStrLOG_MESSAGE
};



#define	EStrSTRNULL	1
#define	EStrSTRENTER	2

#ifdef UNIX
#define EStrNLCR		"\n"
#define EStrSLASH		'/'
#define EStrSLASH_STRING	"/"
#endif

#ifdef WIN32
#define EStrNLCR		"\012\015"
#define EStrSLASH		'\\'
#define EStrSLASH_STRING	"\\"
#endif

enum { EStrCOLOR_NORMAL=0, EStrCOLOR_YELLOW, EStrCOLOR_RED, EStrCOLOR_GREEN, EStrCOLOR_PURPLE, EStrCOLOR_CYAN };

//--------------------------------
// Wildcarding control tokens
//--------------------------------
#define EStrWLC_SINGLE		0x100
#define EStrWLC_MULTI		0x101
#define EStrWLC_SETSTART	0x102
#define EStrWLC_SETEND		0x103
#define EStrWLC_SETGROUP_START	0x104
#define EStrWLC_SETGROUP_SEPRT	0x105
#define EStrWLC_SETGROUP_END	0x106


typedef struct
{
 char	Single[4], Multi[4], SetStart[4], SetEnd[4], SetGrpStart[4], SetGrpSep[4], SetGrpEnd[4];
} EStrFilterTokens;

typedef short	EStrFilterChar;


#ifdef X86CPU
extern inline	volatile u_long64 _x86_GetCycleCount();
#endif

extern EBool	EGetCPUInfo(int* LType, double* LCPUClock, int* LNumOfCPUs);

extern char*	EStr_LaunchPath(char* LCommandLine);


extern char	ENormalColorCode[];
extern char	EBlueCode[];
extern char	ERedCode[];
extern char	EGreenCode[];
extern char	EYellowCode[];
extern char	EPurpleCode[];
extern char	ECyanCode[];

extern char*	EStrDup(char* LStr);

extern int	EStr_DecASCIIUS(register char* LStr, register unsigned long LV, register int LND);
extern int	EStr_DecASCIIUSZB(register char* LStr, register unsigned long LV, register int LND);
extern int	EStr_StrLenT(register char* LString, register unsigned int LEndChars);

extern int	EStr_StringPadToLength(char* LString0, int LLen);

extern char*	EStr_StringGetUnique(char* LString, char** LStrings, int LNumOfStrings);

extern int	EStr_StringsEqual(char* LString0, char* LString1);
extern int	EStr_StringsNEqual(char* LString0, char* LString1, int LLen);

extern char**	EStr_StringListToArray(char* LInStr, unsigned int* LNumOfStringsRet, char LSeparator);

extern int	EStr_FilterTokenize(char* LFilterStr, EStrFilterChar* LFilter, int LMaxLen, EStrFilterTokens* LFilterTokenStrings);
extern int	EStr_FilterAll(EStrFilterChar* LFilter);
extern int	EStr_FilterIsWildcarded(EStrFilterChar* LFilter);
extern int	EStr_FilterPass(char* LStrIn, EStrFilterChar* LFilterIn, int LCaseSensitive);
extern int	EStr_FilterStrPass(char* LStrIn, char* LFilterStrIn, int LCaseSensitive, EStrFilterTokens* LFilterTokenStrings);

extern int	EStr_GetFileNameLength(char* LFullPath);
extern int	EStr_PathIsAbsolute(char* LPath);
extern char*	EStr_CorrectPathName(char* LPath, char* LRet, int LMaxLen);
extern char*	EStr_CorrectPath(char* LPath, char* LRet, int LMaxLen);
extern char*	EStr_GetFileName(char* LFullStr, char* LRet, int LMaxLen);
extern char*	EStr_GetFileNameExtension(char* LFullStr);
extern char*	EStr_GetPathName(char* LFullStr, char* LRet, int LMaxLen);
extern int	EStr_GetLastNonWildPos(char* LPath, EStrFilterTokens* LFilterTokenStrings);
extern int	EStr_GetBasePath(char* LPathS, char* LPathD, char* LExtensionD, char** LExtensions);
extern char*	EStr_GetColorCode(char* LPtr, int LColor);

extern int	Printf(char* LMessage, ...);

extern int	E_ReadFile(char* LFileName, char** LBufferRet, unsigned long* LSizeRet);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EStrings_h
