/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Undo/redo								*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Sep-16 23:49:54					*/
/*									*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.		*/
/*======================================================================*/
#ifndef _EUndo_h
#define _EUndo_h

#ifndef _EResource_h
#include <EResource.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// Operator codes
//
enum
{
 EOpNONE=0,
};


// Status Content codes
//
enum
{
 EActionNONE=0
};


// Function codes for Proc() in EOperator
//
enum
{
 EOpDO=1,
 EOpUNDO,
 EOpFREE
};


typedef struct EOperator_S	EOperator;

typedef unsigned int	(*EOperatorProc)(EOperator*, int);

// This is common in all the Operator-info structures
//
#define EOperatorCore()\
 char*			Name;\
 unsigned int		StructSize;		/* Size of full structure			*/\
 EOperatorProc		Proc;			/* The function that can perform the operation	*/\
\
/* To be able to save/load the undo-stack...*/\
\
 unsigned int	NumOfResources;\
 EResource*	Resources


// The generic EOperator structure
//
struct EOperator_S
{
 EOperatorCore();
};



typedef struct E3dOps
{
 unsigned int	NumOfOperators;
 EOperator**	Operators;
} EOps;



typedef struct
{
 unsigned int		Ptr, NumOfSteps, NumOfStepsAllocated;
 unsigned int		MaxUndoSteps;
 unsigned int		Changed;		// Flags indicating what changed
 EOps*			Steps;
} EUndoStack;



extern int		EOp_AllocStep;


extern EOperator*	EOp_OperatorAllocate(char* LName, unsigned int LStructSize, EOperatorProc LProc);
extern void		EOp_OpsFree(EOps* LOps, EBool LRemove);
extern unsigned int	EOp_RunOps(EOps* LOps, int LAction);
extern void		EOp_UndoStackInit(EUndoStack* LUndoStack);
extern void		EOp_UndoStackFree(EUndoStack* LUndoStack);
extern void		EOp_AppendOps1Operator(EUndoStack* LUndoStack, EOperator* LOperator);

extern EOps*		EOp_Undo(EUndoStack* LStack);
extern EOps*		EOp_Redo(EUndoStack* LStack);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _EUndo_h
