/*==============================================================*/
/* High Range Variable Precision Values				*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	2002-Dec-12 17:21:20				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _ELanguage_h
#define _ELanguage_h

#ifndef _ETypes_h
#include <ETypes.h>
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

// Range bitmasks
//
#define hvMMETER	0x20
#define hvMETER		0x10
#define hvMICRON	0x08
#define hvPICOMETER	0x04

#define hvPp06		0x20	// Ten on the power of   6 (e.g. 1000s of kilometers)
#define hvPp00		0x10	// Ten on the power of   0 (e.g. meters)
#define hvPn06		0x08	// Ten on the power of  -6 (e.g. microns)
#define hvPn12		0x04	// Ten on the power of -12 (e.g. picometers)

typedef struct
{
 int		Pp06,		// Ten on the power of   6 (e.g. 1000s of kilometers)
		Pp00,		// Ten on the power of   0 (e.g. meters)
		Pn06,		// Ten on the power of  -6 (e.g. microns)
		Pn12;		// Ten on the power of -12 (e.g. picometers)
 float		fValue;
 double		dValue;
 unsigned char	Ranges;
} hrvpRec, *hrvp;



extern float	hrvpToFloat(hrvp LHRVP, unsigned char LRange);
extern double	hrvpToDouble(hrvp LHRVP, unsigned char LRange);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _ELanguage_h
