/*==============================================================================*/
/* 2DPanel header file								*/
/*										*/
/* - Tools									*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	1996-Oct-22 23:25:40						*/
/*										*/
/* 2DLib and 2DPanel Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*==============================================================================*/
#ifndef _EPicTools_h
#define _EPicTools_h

#include <Image/2DWindow.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


typedef struct EpToolClass_S	EpToolClass;

typedef struct EpTool_S		EpTool;


#ifdef EpGUI
#define EpToolCore()\
 char			Name[64];\
 EpToolClass*		Class;\
 unsigned int		NumOfInputs;\
 EpTool**		Inputs;\
 unsigned int		NumOfOutputs;\
 EpTool**		Outputs;\
 EpPicture*		Picture;\
 double			XPos, YPos, ZPos;			/* Position of this Tool in the Schematics view	*/\
 unsigned int		NumOfKeyFrames;\
 EpKeyFrameRec*		KeyFrames;\
 EBool			Active;\
 EguiItem		Dialog;\
 Widget			DialogTopMatrixW, ShowResultBW, InteractiveBW, InteractivePropagateBW, UseHardwareBW;\
 EpWindow*		ResultWindow;\
\
 EBool			ShowResult, CacheResult,\
 			Interactive, InteractivePropagate,\
			UseHardware;\
 EBool			ResultDisplayed, ResultPropagated,\
			ReCenterWindow				/* Auto re-center in _Execute			*/
#else

#define EpToolCore()\
 char			Name[64];\
 EpToolClass*		Class;\
 unsigned int		NumOfInputs;\
 EpTool**		Inputs;\
 unsigned int		NumOfOutputs;\
 EpTool**		Outputs;\
 EpPicture*		Picture;\
 double			XPos, YPos, ZPos;			/* Position of this Tool in the Schematics view	*/\
 unsigned long		NumOfKeyFrames;\
 EpKeyFrameRec*		KeyFrames;\
 EBool			ResultPropagated;\
 EBool			Active

#endif	// EpGUI


struct EpTool_S
{
 EpToolCore();
};




struct EpToolClass_S
{
 char		Name[42];
 unsigned int	StructSize;
 int		(*InitRecProc)(EpTool*);
 int		(*FreeRecProc)(EpTool*);
 int		(*ActivateProc)(EpTool*);
 int		(*ExecuteProc)(EpTool*, double, EBool);
 int		(*ConnectionProc)(EpTool*, EpTool**, EpTool**);
 int		(*InputChangedProc)(EpTool*, EpTool*, unsigned int);
 EpImage*	IconImages;
};



extern void		(*Ep_ToolActivateFunction)(EguiItem LGUIItem, EPointer LCallData, EPointer LClientData);
extern void		(*Ep_ExitFunction)(void);
extern void		(*Ep_EventLoopFunction)(EguiEvent*);
extern int		(*Ep_ToolClassRegisterFunction)(EpToolClass*);

extern int		Ep_BinMasks[];
extern EpToolClass**	Ep_ToolClasses;
extern unsigned int	Ep_NumOfToolClasses;
extern EpTool**		Ep_Tools;
extern unsigned int	Ep_NumOfTools;

extern EBool		Ep_ToolClassRegister(EpToolClass* LToolClass);
extern void		Ep_ToolClassRemove(EpToolClass* LToolClass);
extern void		Ep_ToolClassesFree();
extern EpTool*		Ep_ToolNew(EpToolClass* LToolClass);
extern void		Ep_ToolFree(EpTool* LTool);
extern void		Ep_ToolsFree(void);
extern int		Ep_ToolsConnect(EpTool* LFromTool, unsigned long LOutNum, EpTool* LToTool, unsigned long LInNum);
extern int		Ep_ToolPropagateResultToOutput(EpTool* LTool, EpTool* LOutput, unsigned int LFlags);
extern int		Ep_ToolExecute(EpTool* LTool, double LFrame, EBool LPropagateResult);
extern void		Ep_ToolSetResultWindow(EpTool* LTool, EguiItem LShell, Widget LParentW);


extern EguiItem		EpTool_CreateStandardDialog(EpTool* LTool, char* LTitle, char* LIconName, EguiCallbackProc LApplyCallback, EguiCallbackProc LResetCallback, EBool LHWSupport);

extern Widget		EpTool_CreateFolders(Widget LParentW, Widget* LFolderTipsMatrixPtr);

extern Widget		EpTool_AppendFolder(EpTool* LTool, char* LFolderName, Widget LFolderTipsMatrixW, Widget LFoldersMatrixW, Widget LFolderW);

extern Widget		EpTool_CreateAnimationFolder(EpTool* LGUITool, Widget LFolderTipsMatrixW, Widget LFoldersMatrixW);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EPicTools_h
