/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeArrowButton						*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-26 21:26:57				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeArrowButtonP_h
#define _XeArrowButtonP_h

#include <Xe/PrimitiveP.h>
#include <Xe/ArrowButton.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeArrowButtonClassPart
{
 XtPointer	extension;
} XeArrowButtonClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeArrowButtonClassRec
{
 CoreClassPart		core_class;
 XePrimitiveClassPart	xePrimitive_class;
 XeArrowButtonClassPart	xeArrowButton_class;
} XeArrowButtonClassRec;

extern XeArrowButtonClassRec xeArrowButtonClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 Pixel			ArmColor,ArrowArmColor,ForegroundColor,ArrowActiveColor;
 XtCallbackList		ArmCallback,DisarmCallback,ActivateCallback;
 unsigned char		Direction,ArrowBehavior;
 unsigned int		ShadowType;
 Dimension		MarginWidth,MarginHeight,MarginLeft,MarginRight,MarginTop,MarginBottom,ArrowShadowThickness;

// Private variables
 Boolean		Active,Armed;
 GC			DrawGC;
 Pixmap			CachePixmap;
 unsigned char		DragMode;
} XeArrowButtonPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeArrowButtonRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeArrowButtonPart	xeArrowButton;
} XeArrowButtonRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeArrowButtonP_h
