/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeCascadeButton						*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Sep-29 21:27:39				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeCascadeButtonP_h
#define _XeCascadeButtonP_h

#include <Xe/LabelP.h>
#include <Xe/CascadeButton.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


#define XeMENUPANE_CASCADE_ARROWWIDTH		10
#define XeMENUBAR_CASCADE_ARROWWIDTH		8
#define XeOPTIONMENU_CASCADE_BLOCK_XSIZE	14	// The block on the right
#define XeOPTIONMENU_CASCADE_BLOCK_YSIZE	6

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeCascadeButtonClassPart
{
 XtPointer	extension;
} XeCascadeButtonClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeCascadeButtonClassRec
{
 CoreClassPart			core_class;
 XePrimitiveClassPart		xePrimitive_class;
 XeLabelClassPart		xeLabel_class;
 XeCascadeButtonClassPart	xeCascadeButton_class;
} XeCascadeButtonClassRec;

extern XeCascadeButtonClassRec xeCascadeButtonClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 Pixel			ArmColor;
 XtCallbackList		ArmCallback, DisarmCallback, ActivateCallback;
 Widget			SubMenuID;
 int			MappingDelay, PostMenuTo;
 Pixmap			ArmPixmap, ArmPixmapMask;

// Private variables
 int			DefShadowSpacing;
 GC			DrawGC;
 Pixmap			CachePixmap;
 Boolean		Active, Armed, MenuPosted, ShowArrow;
 unsigned char		DragMode;
} XeCascadeButtonPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeCascadeButtonRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeLabelPart		xeLabel;
 XeCascadeButtonPart	xeCascadeButton;
} XeCascadeButtonRec;


extern void	_XeCascadeButtonRedraw(Widget LW);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeCascadeButtonP_h
