/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeFileSelectionBox						*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Dec-14 00:30:31				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeFileSelectionBoxP_h
#define _XeFileSelectionBoxP_h

#include <Xe/MessageBoxP.h>
#include <Xe/FileSelBox.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeFileSelectionBoxClassPart
{
 XtPointer	extension;
} XeFileSelectionBoxClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeFileSelectionBoxClassRec
{
 CoreClassPart			core_class;
 CompositeClassPart		composite_class;
 ConstraintClassPart		constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart		xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart		xeManager_class;

 XeBoardClassPart		xeBoard_class;
 XeMessageBoxClassPart		xeMessageBox_class;
 XeFileSelectionBoxClassPart	xeFileSelectionBox_class;
} XeFileSelectionBoxClassRec;

extern XeFileSelectionBoxClassRec xeFileSelectionBoxClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
 Widget		OkButtonW,RefreshButtonW,ListsButtonW,CancelButtonW;
 Widget		CustomFormW;
} XeFileSelectionBoxPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeFileSelectionBoxRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;

 XeBoardPart		xeBoard;
 XeMessageBoxPart	xeMessageBox;
 XeFileSelectionBoxPart	xeFileSelectionBox;
} XeFileSelectionBoxRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeFileSelectionBoxP_h
