/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeLayout							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-26 21:23:30				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeLayoutP_h
#define _XeLayoutP_h

#include <Xe/ManagerP.h>
#include <Xe/Layout.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeLayoutClassPart
{
 XtPointer	extension;
} XeLayoutClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeLayoutClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;

 XeLayoutClassPart	xeLayout_class;
} XeLayoutClassRec;

extern XeLayoutClassRec xeLayoutClassRec;




/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
//
 Dimension		XSpacing, YSpacing,
			MarginXSize, MarginYSize;
 unsigned int		ShadowType;

 XePreferredSizeProc	PreferredSizeProc;			// Custom function to lay out XeManager's children and compute XeManager's preferred size
 XeLayoutProc		LayoutProc;				// Custom function to lay out XeManager children with a given XeManager size

// Private variables
//
 GC			DrawGC;
} XeLayoutPart;


/*==============================*/
/* Constraint resources		*/
/*==============================*/
typedef struct _XeLayoutConstraintPart
{
 Dimension		PreferredXSize, PreferredYSize;
 Dimension		XSizeByLayout, YSizeByLayout;

 Position		X, Y;
 int			XSize, YSize;
 int			XSizeProposed, YSizeProposed;	// The size for this child that XeLayout's geometry_manager returned with an XtGeometryAlmost
 Boolean		XSizeAdjustable, YSizeAdjustable;
} XeLayoutConstraintPart;


typedef struct _XeLayoutConstraintRec
{
 XeLayoutConstraintPart	Layout;
} XeLayoutConstraintRec, *XeLayoutConstraints;




/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeLayoutRec
{
 CorePart	core;
 CompositePart	composite;
 ConstraintPart	constraint;

#ifdef _XeUSEXm
 XmManagerPart	xmManager;
#endif // _XeUSEXm

 XeManagerPart	xeManager;

 XeLayoutPart	xeLayout;
} XeLayoutRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeLayoutP_h
