/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeList								*/
/* Public header file							*/
/*									*/
/* DATE:	1996-Jun-09 22:25:54					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeListWidget_h
#define _XeListWidget_h

#include <Xe/Xe.h>
#include <Xe/Primitive.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


typedef struct
{
 int		reason;
 XEvent*	event;
 XeString	item;
 int		item_length;
 int		item_position;
 XeString*	selected_items;
 int		selected_item_count;
 int*		selected_item_positions;
 char		selection_type;
 char		auto_selection_type;
} XeListCallbackStruct;


extern WidgetClass xeListWidgetClass;
typedef struct _XeListClassRec*		XeListWidgetClass;
typedef struct _XeListRec*		XeListWidget;

extern void	XeListAddItemUnselected(Widget LW, XeString LItem, int LPosition);
extern void	XeListDeleteAllItems(Widget LW);
extern Boolean	XeListGetSelectedPos(Widget LW, int** LPosListRet, int* LPosCountRet);
extern Boolean	XeListItemExists(Widget LW, XeString LItem);
extern Widget	XeCreateScrolledList(Widget LParentW, char* LName, ArgList LArgs, Cardinal LNumOfArgs);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeListWidget_h
