/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeList								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Jun-12 23:44:55					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeListP_h
#define _XeListP_h

#include <Xe/PrimitiveP.h>
#include <Xe/List.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeListClassPart
{
 XtPointer	extension;
} XeListClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeListClassRec
{
 CoreClassPart		core_class;
 XePrimitiveClassPart	xePrimitive_class;
 XeListClassPart	xeList_class;
} XeListClassRec;

extern XeListClassRec xeListClassRec;


typedef struct
{
 Pixmap			ItemPixmap;
 XeStringBinarySegment*	BinaryString;
 int			NumOfSegmentsInString;
 int			XSize, YSize, StringXSize, StringYSize, PixmapXSize, PixmapYSize;
 Boolean		Selected;
} XeListItem;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
//
 Pixel				ForegroundColor, HighlightColor;
 Dimension			MarginLeft, MarginRight, MarginTop, MarginBottom, MarginXSize, MarginYSize;
 Dimension			XSpacing, YSpacing;
 XeFontList			FontList;

 int				NumOfItems;
 int				VisibleItemCount,
				TopItemPosition;

 Boolean			RecomputeSize;

 XtCallbackList			BrowseSelectionCallback, DefaultActionCallback,
				ExtendedSelectionCallback, MultipleSelectionCallback, SingleSelectionCallback;

 char				ShadowType;


// Internal variables
//
 XeListItem**			Items;
 GC				DrawGC;
} XeListPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeListRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeListPart		xeList;
} XeListRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeListP_h
