/*======================================================================*/
/* 'Xe' ERIDANI Widget set						*/
/* All rights reserved							*/
/*									*/
/* XeManager								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Sep-05 22:37:27					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeManagerP_h
#define _XeManagerP_h

#include <Xe/XeP.h>
#include <Xe/Manager.h>

#ifdef _XeUSEXm
#include <Xm/ManagerP.h>
#endif // _XeUSEXm


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeManagerClassPart
{
 XtPointer	extension;
} XeManagerClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeManagerClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;
} XeManagerClassRec;

extern XeManagerClassRec xeManagerClassRec;



/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
 int			UserData;

 XVisualInfo*		VisualInfo;

// Resources
 int			RedrawPolicy;				// Tells the subclass how to redraw itself
 Dimension		ShadowThickness;
 Pixel			TopShadowColor, TopShadowColor2,	// A brighter and a slightly darker TopShadowColor
			BottomShadowColor, BottomShadowColor2;	// A darker and a slightly brighter TopShadowColor

 Boolean		RecomputeXSize, RecomputeYSize;		// Recompute preferred size and make requests to parent when chldren change

// Private variables
//
 unsigned int		NumOfManagedChildren;			// Keeping managed children in a separate array makes our life easier...
 Widget*		ManagedChildren;
 Widget			ChildWithFocus;

 Dimension		MinXSize, MinYSize, MaxXSize, MaxYSize;

 Boolean		DoLayoutInExpose;			// Call Layout in expose method before redrawing

 Boolean		ClearBackground;			// Let X clear the background on expose or not
 Boolean		ShadowColorsDefined;			// TopShadow and/or BottomShadow colord were given by the application
} XeManagerPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeManagerRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm
 XeManagerPart		xeManager;
} XeManagerRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeManagerP_h
