/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeMatrix							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Oct-19 21:23:30				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeMatrixP_h
#define _XeMatrixP_h

#include <Xe/ManagerP.h>
#include <Xe/Matrix.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeMatrixClassPart
{
 XtPointer	extension;
} XeMatrixClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeMatrixClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;

 XeMatrixClassPart	xeMatrix_class;
} XeMatrixClassRec;

extern XeMatrixClassRec xeMatrixClassRec;




/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
//
 Dimension	MarginXSize, MarginYSize;
 int		XSpacing, YSpacing;
 unsigned int	ShadowType;
 unsigned int	NumOfColumns, NumOfRows;
 char		Orientation;
 Boolean	RadioBehavior, RadioAlwaysOne, AdjustEntryXSize, AdjustEntryYSize;

// Private variables
//
 Widget		LabelW;		// Label
 GC		DrawGC;
} XeMatrixPart;


/*==============================*/
/* Constraint resources		*/
/*==============================*/
typedef struct _XeMatrixConstraintPart
{
 Dimension		PreferredXSize, PreferredYSize;
 Dimension		XSizeByMatrix, YSizeByMatrix;

 Position		X, Y;
 int			XSize, YSize;
 int			XSizeProposed, YSizeProposed;	// The size for this child that XeMatrix's geometry_manager returned with an XtGeometryAlmost

 char			XAlignment, YAlignment;		// How to align child widget within enclosing box, when *SizeAdjustable is False
 Boolean		XSizeAdjustable, YSizeAdjustable;
} XeMatrixConstraintPart;


typedef struct _XeMatrixConstraintRec
{
 XeMatrixConstraintPart	Matrix;
} XeMatrixConstraintRec, *XeMatrixConstraints;




/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeMatrixRec
{
 CorePart	core;
 CompositePart	composite;
 ConstraintPart	constraint;

#ifdef _XeUSEXm
 XmManagerPart	xmManager;
#endif // _XeUSEXm

 XeManagerPart	xeManager;

 XeMatrixPart	xeMatrix;
} XeMatrixRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeMatrixP_h
