/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeMenu							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-May-12 22:34:50				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeMenuP_h
#define _XeMenuP_h

#include <Xe/ManagerP.h>
#include <Xe/Menu.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeMenuClassPart
{
 XtPointer	extension;
} XeMenuClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeMenuClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;

 XeMenuClassPart	xeMenu_class;
} XeMenuClassRec;

extern XeMenuClassRec xeMenuClassRec;


// Constraint resources
//
typedef struct _XeMenuConstraintPart
{
 Dimension		PreferredXSize, PreferredYSize;
 Dimension		XSizeByMenu, YSizeByMenu;

 Position		X, Y;
 int			XSize, YSize;
 int			XSizeProposed, YSizeProposed;	// The size for this child that XeMenu's geometry_manager returned with an XtGeometryAlmost
} XeMenuConstraintPart;


typedef struct _XeMenuConstraintRec
{
 XeMenuConstraintPart	Menu;
} XeMenuConstraintRec,*XeMenuConstraints;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
 Dimension	XSpacing, YSpacing,
		MarginXSize, MarginYSize,
		CastShadowWidth,
		LeftObjectWidth;		// In a menu pane, a left arrow, a ToggleButton indicator or a PushButton MenuSubButton
 unsigned int	ShadowType;
 char		Type, Orientation;
 Boolean	RadioBehavior, RadioAlwaysOne;

// Private variables
//
 Window		ShadowBWindow, ShadowRWindow;	// Cast shadow windows (one on the below and one on the right side of the menu pane)
 Pixmap		ShadowBMask, ShadowRMask;	// Cast shadow masks

 Widget		OptionMenuCascadeButtonW;	// OptionMenu's CascadeButton
 Widget		MenuPaneCascadeButtonW;		// If it's an OptionMenu pane, we need a back reference to the CascadeButton it's attached to via SubMenuID
 Widget		LabelW,				// Label
		ActiveMenuButtonW;		// The active button widget in the menu pane
 Widget		LastActiveMenuButtonW;		// The last active button widget in the menu pane (need it for 'cancelling a selection')
 Widget		LastActivatedButtonW;		// Button widget that was last activated (callback called)
 GC		DrawGC;
} XeMenuPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeMenuRec
{
 CorePart	core;
 CompositePart	composite;
 ConstraintPart	constraint;

#ifdef _XeUSEXm
 XmManagerPart	xmManager;
#endif // _XeUSEXm

 XeManagerPart	xeManager;
 XeMenuPart	xeMenu;
} XeMenuRec;


extern Boolean	_XeIsInMenuPane(Widget LW);
extern void	_XePopUpMenuPane(Widget LMenuPaneW, Widget LCascadeBW, Position LX, Position LY);
extern void	_XePopDownMenuPane(Widget LMenuPaneW);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeMenuP_h
