/*==============================================================*/
/* 'Xe' ERIDANI Widget set by					*/
/*								*/
/* XeMessageBox							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-20 23:15:05				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeMessageBoxP_h
#define _XeMessageBoxP_h

#include <Xe/BoardP.h>
#include <Xe/MessageBox.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeMessageBoxClassPart
{
 XtPointer	extension;
} XeMessageBoxClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeMessageBoxClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;
 XeBoardClassPart	xeBoard_class;
 XeMessageBoxClassPart	xeMessageBox_class;
} XeMessageBoxClassRec;

extern XeMessageBoxClassRec xeMessageBoxClassRec;



/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
 int		NumOfButtons;
 Dimension	WorkAreaMarginXSize, WorkAreaMarginYSize;
 Dimension	ButtonSpacing, ButtonXSize, ButtonYSize, ButtonsYSize;
 Widget*	Buttons;
 Widget		WorkAreaW, SeparatorW;
 XtCallbackList	OkCallback, CancelCallback, HelpCallback;

 Boolean	CreateSeparator, CreateButtons, StretchButtons;

// Private variables
//
 Boolean	DoLayout;
} XeMessageBoxPart;


// Constraint resources
//
typedef struct _XeMessageBoxConstraintPart
{
 Boolean	Resizable;
 Dimension	PreferredXSize, PreferredYSize;


 Position	X, Y;
 int		XSize, YSize;
 Dimension	XSizeByMessageBox, YSizeByMessageBox;
 int		XSizeProposed, YSizeProposed;	// The size for this child that XeMessageBox's geometry_manager returned with an XtGeometryAlmost
} XeMessageBoxConstraintPart;


typedef struct _XeMessageBoxConstraintRec
{
 XeMessageBoxConstraintPart	MessageBox;
} XeMessageBoxConstraintRec, *XeMessageBoxConstraints;



/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeMessageBoxRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;
 XeBoardPart		xeBoard;
 XeMessageBoxPart	xeMessageBox;
} XeMessageBoxRec;


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeMessageBoxP_h
