/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeScale								*/
/* Public header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-May-20 23:04:24					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeScaleWidget_h
#define _XeScaleWidget_h

#include <Xe/Manager.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

extern WidgetClass xeScaleWidgetClass;
typedef struct _XeScaleClassRec*	XeScaleWidgetClass;
typedef struct _XeScaleRec*		XeScaleWidget;



typedef struct
{
 int	TopValue;
 Pixel	Color;
} XeThermometerRange;


typedef struct
{
 double	FloatValue;
 int	IntValue;
 char	Decimals;
} XeScaleCallbackStruct;


extern Boolean	XeTextF;

extern void	XeScaleSetValue(Widget LWidget, int LValue, Boolean LNotify);
extern void	XeScaleSetRangeAndValue(Widget LWidget, int LMinimum, int LMaximum, int LValue, Boolean LNotify);
extern void	XeScaleSetRangesAndValue(Widget LWidget, int LMinimum, int LMaximum, int LScaleMinimum, int LScaleMaximum, int LValue, Boolean LNotify);
extern int	XeScaleGetValue(Widget LWidget);
extern void	XeScaleSetValueD(Widget LWidget, double LValue, Boolean LNotify);
extern void	XeScaleSetRangeAndValueD(Widget LWidget, double LMinimum, double LMaximum, double LValue, Boolean LNotify);
extern void	XeScaleSetRangesAndValueD(Widget LWidget, double LMinimum, double LMaximum, double LScaleMinimum, double LScaleMaximum, double LValue, Boolean LNotify);
extern double	XeScaleGetValueD(Widget LWidget);

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeScaleWidget_h
