/*======================================================================*/
/* 'Xe' ERIDANI Widget							*/
/*									*/
/* XeScale								*/
/* Private header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-25 23:57:43					*/
/*									*/
/* Xe(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeScaleP_h
#define _XeScaleP_h

#include <Xe/ManagerP.h>
#include <Xe/LabelP.h>
#include <Xe/Scale.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

//================================
// Class definition
//================================
// Class part=
//================================
typedef struct _XeScaleClassPart
{
 XtPointer	extension;
} XeScaleClassPart;


//================================
// Class record
//================================
typedef struct _XeScaleClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;
 XeScaleClassPart	xeScale_class;
} XeScaleClassRec;

extern XeScaleClassRec xeScaleClassRec;



//================================
// Instance definition
//================================
// Instance part
//================================
typedef struct
{
// Resources
 int			TextFieldDigits;

 fixed			HMinimum, HMaximum, HIncrement, HValue, HResetValue, HAlignTo, HAlignOffset, ScaleHMinimum, ScaleHMaximum, ScaleHValue;

 int			IMinimum, IMaximum, IIncrement, IValue, IResetValue, IAlignTo, IAlignOffset, ScaleIMinimum, ScaleIMaximum, ScaleIValue;
 double			FMinimum, FMaximum, FIncrement, FValue, FResetValue, FAlignTo, FAlignOffset, ScaleFMinimum, ScaleFMaximum, ScaleFValue;
 XtCallbackList		ValueChangedCallback, ActivateCallback, TextFieldChgCallback, DragCallback;

 XeFontList		TextFieldFontList;

 unsigned int		ShadowType;
 unsigned char		ValueType, ScaleType, Decimals, Orientation, LabelPlacement, TextFieldPlacement, ButtonPlacement;

 Boolean		ActivateOnLeave, CorrectOnLeave, ActivateOnTextChange;
 Boolean		ScaleGroove, CreateLabel, CreateScale, CreateTextField, CreateUpButton, CreateDownButton, CreateResetButton;
 Boolean		Editable,
			ThermoFlow;		// Applied when the thermometer pixmap is not solid, determines whether the
						// thermometer 'bar' is like a flowing fluid or a sliding bar

 Dimension		SpacingX, SpacingY,
			ScaleWidthInPixels, ScaleLengthInPixels, ScaleShadowThickness,
			TextFieldXSize, TextFieldYSize, TextFieldShadowThickness,
			SliderLengthInPixels, SliderPixmapXSize, SliderPixmapYSize,
			ScalePixmapXSize, ScalePixmapYSize,
			ThermoPixmapXSize, ThermoPixmapYSize;

 int			ScalePitWOffset;	// Offset of the scale 'pit' from the edge of the scale area (perpendicular to the scale orientation)
 int			SliderWOffset;		// Offset of the slider from the edge of the scale area (perpendicular to the scale orientation)

 Pixel			ActiveColor, SliderColor, SliderActiveColor,
			SliderTopShadowColor, SliderTopShadowColor2, SliderBottomShadowColor, SliderBottomShadowColor2,
			LabelColor, TroughColor, TextBackgroundColor, TextForegroundColor, TextHighlightColor, CursorColor,
			ThermoColor, ThermoTopShadowColor, ThermoTopShadowColor2, ThermoBottomShadowColor, ThermoBottomShadowColor2;
 Dimension		ThermoGapWidth, ThermoShadowThickness;

 int			SliderBorderWidth;

 void*			ValueArray;		// For non-linear sliders, here are the values for the range
						// of min-max (int* or double*, depending on the ValueType)
 int			ValueCount;		// Count of values in the Values array
 int			ValueIndex;		// Index to the current value in the ValueArray

 int			RangeCount;
 XeThermometerRange*	RangeList;

// Read-only resources
 Widget			TextFieldW, UpButtonW, DownButtonW, ResetButtonW;


// Private variables
 int			PointerLocation;				// Tells wheter the pointer is outside, on the scale area or on the slider
 Position		ScaleX, ScaleY, SliderDragOffset, SliderX, SliderY,
			SliderWidthInPixels, SliderPositionInPixels,
			TextFieldX, TextFieldY,
			UpDownButtonX, UpButtonY, DownButtonY,
			ResetButtonX, ResetButtonY;

 Pixmap			ScalePixmap, SliderPixmap, SliderMask, ThermoPixmap;

 Dimension		ScaleAreaWidth, SliderIntendedLength, SetButtonXSize, SetButtonYSize,
			ThermoLength;

 Boolean		DragMode, PrgChangedTextField, LabelStringCreatedFromName;
 int			BarLengthInPixels;						// For faster redraw of the Bar

 GC			DrawGC;
 Boolean		SliderPixmapGiven, SliderMaskGiven;
} XeScalePart;


//================================
// Instance record
//================================
typedef struct _XeScaleRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;
 XeLabelPart		xeLabel;
 XeScalePart	xeScale;
} XeScaleRec;

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeScaleP_h
