/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeScrollBar								*/
/* Public header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Jan-04 22:48:47					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeScrollBarWidget_h
#define _XeScrollBarWidget_h

#include "Xe.h"
#include "Manager.h"
#include "ArrowButton.h"

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

extern WidgetClass xeScrollBarWidgetClass;
typedef struct _XeScrollBarClassRec*	XeScrollBarWidgetClass;
typedef struct _XeScrollBarRec*		XeScrollBarWidget;


typedef struct
{
 int		Reason;
 int		Value, Minimum, Maximum;
 int		ScaleXSize, ScaleYSize;
 int		SliderXSize, SliderYSize;
 Pixmap*	ScalePixmap;
 Pixmap*	SliderPixmap;
} XeScrollBarCallbackStruct;


extern void	XeScrollBarSetValue(Widget LWidget, int LValue, Boolean LNotify);
extern void	XeScrollBarSetRangeAndValue(Widget LWidget, int LMinimum, int LMaximum, int LValue, Boolean LNotify);
extern int	XeScrollBarGetValue(Widget LWidget);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeScrollBarWidget_h
