/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeScrollBar							*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-04 23:55:40				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeScrollBarP_h
#define _XeScrollBarP_h

#include <Xe/ManagerP.h>
#include <Xe/ScrollBar.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeScrollBarClassPart
{
 XtPointer	extension;
} XeScrollBarClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeScrollBarClassRec
{
 CoreClassPart		core_class;
 CompositeClassPart	composite_class;
 ConstraintClassPart	constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart	xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart	xeManager_class;
 XeScrollBarClassPart	xeScrollBar_class;
} XeScrollBarClassRec;

extern XeScrollBarClassRec xeScrollBarClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
 int			IMinimum, IMaximum, IIncrement, IValue, IAlignTo, IAlignOffset;
 XtCallbackList		ValueChangedCallback, DragCallback;

 unsigned int		ShadowType;

 unsigned char		Orientation, ButtonPlacement, ScaleType;
 Boolean		CreateScale, ScaleGroove, CreateUpButton, CreateDownButton;
 Boolean		SliderActive, Alive, Editable;

 Dimension		MarginXSize, MarginYSize,
			ScaleWidthInPixels, ScaleLengthInPixels, ScaleShadowThickness,
			SliderMinimumLengthInPixels, SliderLengthInPixels, SliderPixmapXSize, SliderPixmapYSize,
			ScalePixmapXSize, ScalePixmapYSize;

 Pixel			ButtonColor, ActiveColor,
			SliderColor, SliderActiveColor, SliderBorderColor,
			SliderTopShadowColor, SliderTopShadowColor2, SliderBottomShadowColor, SliderBottomShadowColor2,
			TroughColor;

 int			SliderLength, SliderBorderWidth, ScaleBOffset, ScaleBIOffset;

 int			SmoothScrollSteps;

// Read-only resources
 Widget			UpButtonW, DownButtonW;


// Private variables
 XtIntervalId		SmoothScrollTimerId;

 int			SmoothValueTarget, SmoothSubStep;
 int			PointerLocation;				// Tells wheter the pointer is outside, on the scale area or on the slider
 Position		ScaleX, ScaleY, SliderDragOffset, SliderX, SliderY,
			SliderWidthInPixels, SliderPositionInPixels,
			ResetButtonX, ResetButtonY;

 Pixmap			ScalePixmap, SliderPixmap, SliderMask;

 Dimension		ScaleAreaWidth, SliderIntendedLength;

 Boolean		DragMode;
 int			SetButtonXSize, SetButtonYSize;

 GC			DrawGC;
 Boolean		SliderPixmapGiven, SliderMaskGiven;
} XeScrollBarPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeScrollBarRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;
 XeScrollBarPart	xeScrollBar;
} XeScrollBarRec;

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeScrollBarP_h
