/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeScrolledWindow						*/
/* Private header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jan-04 22:30:22				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeScrolledWindowP_h
#define _XeScrolledWindowP_h

#include <Xe/ManagerP.h>
#include <Xe/ScrolledWindow.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeScrolledWindowClassPart
{
 XtPointer	extension;
} XeScrolledWindowClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeScrolledWindowClassRec
{
 CoreClassPart			core_class;
 CompositeClassPart		composite_class;
 ConstraintClassPart		constraint_class;

#ifdef _XeUSEXm
 XmManagerClassPart		xmManager_class;
#endif // _XeUSEXm

 XeManagerClassPart		xeManager_class;
 XeScrolledWindowClassPart	xeScrolledWindow_class;
} XeScrolledWindowClassRec;

extern XeScrolledWindowClassRec xeScrolledWindowClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
//
 unsigned int		ShadowType, ScrollingPolicy, ScrollBarDisplayPolicy;

 Dimension		MarginXSize, MarginYSize;		// Between the main shadows and the ScrollBars
 Dimension		Spacing;				// Between the ScrollBars and the WorkWindow

 Widget			HScrollBarW, VScrollBarW,
			WorkWindowW;				// The widget to be scrolled

 Pixel			ButtonColor, SliderColor;

// Private variables
//
 Widget			ClipWindowW;				// The actual parent of widget to be scrolled
 int			WorkWindowXOffset, WorkWindowYOffset;	// Pixel of WorkWindow Widget in the top-left corner of the ScrollerWindow's area
 Position		ClipWX, ClipWY, ClipWXSize, ClipWYSize, HScrollbarX, HScrollbarY, VScrollbarX, VScrollbarY;
 Dimension		WorkAreaShadowThickness, WorkWindowXSize, WorkWindowYSize,
			HScrollBarXSize, HScrollBarYSize, VScrollBarXSize, VScrollBarYSize;

 GC			DrawGC;
 Boolean		SliderColorGiven, ButtonColorGiven,
			IgnoreChangedManaged;
} XeScrolledWindowPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeScrolledWindowRec
{
 CorePart		core;
 CompositePart		composite;
 ConstraintPart		constraint;

#ifdef _XeUSEXm
 XmManagerPart		xmManager;
#endif // _XeUSEXm

 XeManagerPart		xeManager;
 XeScrolledWindowPart	xeScrolledWindow;
} XeScrolledWindowRec;

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeScrolledWindowP_h
