/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeTextField							*/
/* Public header file						*/
/*								*/
/* AUTHOR:	Gabor Nagy					*/
/* DATE:	1996-Jun-05 23:36:46				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeTextFieldWidget_h
#define _XeTextFieldWidget_h

#include <Xe/Xe.h>
#include <Xe/Primitive.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

extern WidgetClass xeTextFieldWidgetClass;
typedef struct _XeTextFieldClassRec*	XeTextFieldWidgetClass;
typedef struct _XeTextFieldRec*		XeTextFieldWidget;


typedef struct
{
 int		reason;
 XEvent*	event;
} XeTextFieldCallbackStruct;



extern void		XeTextFieldSetString(Widget LW, char* LString);
extern char*		XeTextFieldGetString(Widget LW);
extern void		XeTextFieldInsert(Widget LW, XeTextPosition LHere, char* LString);

extern void		XeTextFieldClearSelection(Widget LW, Time LTime);

extern void		XeTextFieldSetSelection(Widget LW, XeTextPosition LStart, XeTextPosition LEnd, Time LTime);

extern XeTextPosition	XeTextFieldGetLastPosition(Widget LW);
extern void		XeTextFieldSetInsertionPosition(Widget LW, XeTextPosition LPos);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeTextFieldWidget_h
