/*======================================================================*/
/* Xe Widget set							*/
/*									*/
/* XeToggleButton							*/
/* Public header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Oct-05 23:15:33					*/
/*									*/
/* Xe Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeToggleButtonWidget_h
#define _XeToggleButtonWidget_h

#include <Xe/Label.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

extern WidgetClass xeToggleButtonWidgetClass;
typedef struct _XeToggleButtonClassRec*	XeToggleButtonWidgetClass;
typedef struct _XeToggleButtonRec*	XeToggleButtonWidget;

enum
{
 XeBUTTONTYPE_TOGGLE=0,
 XeBUTTONTYPE_LED,
 XeBUTTONTYPE_FOLDER_TOP,		// Folder tab above
 XeBUTTONTYPE_FOLDER_BOTTOM,		// Folder tab below
 XeBUTTONTYPE_FOLDER_LEFT,		// Folder tab to the left
 XeBUTTONTYPE_FOLDER_RIGHT		// Folder tab to the right
};

enum
{
 XeN_OF_MANY=0, XeONE_OF_MANY, XeN_OF_MANY_FULL_HEIGHT
};

typedef struct
{
 int		reason;
 XEvent*	event;
 int		click_count;
 Boolean	set;
} XeToggleButtonCallbackStruct;


extern void	XeToggleButtonSetState(Widget LWidget,Boolean LValue,Boolean LNotify);
extern Boolean	XeToggleButtonGetState(Widget LWidget);
extern void	XeToggleButtonArm(Widget LW);
extern void	XeToggleButtonDisarm(Widget LW);

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeToggleButtonWidget_h
