/*==============================================================*/
/* 'Xe' ERIDANI Widget set					*/
/*								*/
/* XeToggleButton						*/
/* Private header file						*/
/*								*/
/* DATE:	1996-Oct-05 22:47:03				*/
/*								*/
/* Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================*/
#ifndef _XeToggleButtonP_h
#define _XeToggleButtonP_h

#include <Xe/LabelP.h>
#include <Xe/MenuButtonP.h>
#include <Xe/ToggleButton.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

/*==============================*/
/* Class definition		*/
/*==============================*/
/* Class part			*/
/*==============================*/
typedef struct _XeToggleButtonClassPart
{
 XtPointer	extension;
} XeToggleButtonClassPart;


/*==============================*/
/* Class record			*/
/*==============================*/
typedef struct _XeToggleButtonClassRec
{
 CoreClassPart			core_class;
 XePrimitiveClassPart		xePrimitive_class;
 XeLabelClassPart		xeLabel_class;
 XeToggleButtonClassPart	xeToggleButton_class;
} XeToggleButtonClassRec;

extern XeToggleButtonClassRec xeToggleButtonClassRec;


/*==============================*/
/* Instance definition		*/
/*==============================*/
/* Instance part		*/
/*==============================*/
typedef struct
{
// Resources
//
 Pixel			ArmColor, CheckMarkColor,
			IndicatorColor, IndicatorTopShadowColor, IndicatorTopShadowColor2, IndicatorBottomShadowColor, IndicatorBottomShadowColor2,
			SelectColor;
 EpImage*		ArmRGBAImage, ActiveRGBAImage;
 Pixmap			ArmPixmap, ArmPixmapMask, ActivePixmap, ActivePixmapMask;
 XtCallbackList		ArmCallback, DisarmCallback, ActivateCallback, ValueChangedCallback;
 int			DefaultButtonShadowThickness;
 Dimension		IndicatorSize, IndicatorGapWidth, IndicatorShadowThickness, XSpacing, Spacing;
 unsigned char		ButtonType, IndicatorType;
 Boolean		ActivateOnArm, Set,
			IndicatorOn, CheckMarkOn,
			FillOnSelect, VisibleWhenOff, ShowAsDefault;
 Widget			FolderWidget;

// Private variables
//
 int			DefShadowSpacing;
 Dimension		IndicatorXSize, IndicatorYSize;
 Position		IndicatorX, IndicatorY;
 Boolean		IndicatorXSizeGiven, Active, Armed;
 unsigned char		DragMode;
} XeToggleButtonPart;


/*==============================*/
/* Instance record		*/
/*==============================*/
typedef struct _XeToggleButtonRec
{
 CorePart		core;
 XePrimitivePart	xePrimitive;
 XeLabelPart		xeLabel;
 XeMenuButtonPart	xeMenuButton;
 XeToggleButtonPart	xeToggleButton;
} XeToggleButtonRec;

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _XeToggleButtonP_h
