/*==============================================================================*/
/* Xe Widget set								*/
/*										*/
/* Main public header file							*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	1996-Jun-24 22:17:59						*/
/*										*/
/* Xe(TM) Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================================*/
#ifndef _Xe_h
#define _Xe_h

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <Image/Image.h>

#define _XeUSEXm		// FIXME For now use Motif for a few things

#include <Xe/XeStrDefs.h>	// This must be after defining _XeUSEXm

#ifdef _XeUSEXm
#include <Xm/Xm.h>		// ...
#endif // _XeUSEXm

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


// Unit types
//
enum
{
 XePIXELS,
 Xe100TH_MILLIMETERS,
 Xe1000TH_INCHES,
 Xe100TH_POINTS,
 Xe100TH_FONT_UNITS
};


// Shadow types
//
#define XeSHADOW_NONE		0
#define XeSHADOW_OUT_LEFT	1
#define XeSHADOW_OUT_RIGHT	(1<<1)
#define XeSHADOW_OUT_TOP	(1<<2)
#define XeSHADOW_OUT_BOTTOM	(1<<3)
#define XeSHADOW_OUT		(XeSHADOW_OUT_LEFT|XeSHADOW_OUT_RIGHT|XeSHADOW_OUT_TOP|XeSHADOW_OUT_BOTTOM)
#define XeSHADOW_IN_LEFT	(1<<4)
#define XeSHADOW_IN_RIGHT	(1<<5)
#define XeSHADOW_IN_TOP		(1<<6)
#define XeSHADOW_IN_BOTTOM	(1<<7)
#define XeSHADOW_IN		(XeSHADOW_IN_LEFT|XeSHADOW_IN_RIGHT|XeSHADOW_IN_TOP|XeSHADOW_IN_BOTTOM)
#define XeSHADOW_ETCHED_IN	(XeSHADOW_OUT_LEFT|XeSHADOW_OUT_RIGHT|XeSHADOW_OUT_TOP|XeSHADOW_OUT_BOTTOM|XeSHADOW_IN_LEFT|XeSHADOW_IN_RIGHT|XeSHADOW_IN_TOP|XeSHADOW_IN_BOTTOM)

// Top folder tip
//
#define XeSHADOW_OUT_TOP_TIP	(XeSHADOW_OUT_LEFT|XeSHADOW_OUT_RIGHT|XeSHADOW_OUT_TOP)


#define XeSHADOW_DIRECTION	0xFF

#define XeSHADOW_ROUNDED	(1<<8)
#define XeSHADOW_SPECIALS	(XeSHADOW_ROUNDED)



// Resize types
//
enum
{
 XeRESIZE_NONE, XeRESIZE_GROW, XeRESIZE_ANY
};


enum
{
 XeVARIABLE, XeCONSTANT, XeRESIZE_IF_POSSIBLE
};


// Label type flags
//
enum
{
 XeSTRING=0, XePIXMAP, XeSTRING_PIXMAP_HORIZONTAL, XePIXMAP_STRING_HORIZONTAL, XeSTRING_PIXMAP_VERTICAL, XePIXMAP_STRING_VERTICAL
};

// Scale type flags
//
#define XeCUSTOM_SLIDER	0
#define XeSLIDER	1
#define XeTHERMOMETER	(1<<1)

// Alignments
//
enum { XeALIGN_BEGINNING=0, XeALIGN_END, XeALIGN_CENTER, XeALIGN_JUSTIFY };

// Arrow behaviors
//
enum { XeARROW_PUSH_IN=0, XeARROW_ALWAYS_IN };

// Callback reasons
//
enum
{
 XeCR_NONE=0,
 XeCR_HELP,
 XeCR_VALUE_CHANGED,
 XeCR_INCREMENT,XeCR_DECREMENT,	
 XeCR_PAGE_INCREMENT,XeCR_PAGE_DECREMENT,
 XeCR_TO_TOP,XeCR_TO_BOTTOM,
 XeCR_DRAG,
 XeCR_ACTIVATE,
 XeCR_ARM,
 XeCR_DISARM,
 XeCR_MAP, XeCR_UNMAP,
 XeCR_FOCUS, XeCR_LOSING_FOCUS,
 XeCR_MODIFYING_TEXT_VALUE,
 XeCR_MOVING_INSERT_CURSOR,
 XeCR_EXECUTE,
 XeCR_SINGLE_SELECT, XeCR_MULTIPLE_SELECT, XeCR_EXTENDED_SELECT, XeCR_BROWSE_SELECT,
 XeCR_DEFAULT_ACTION,
 XeCR_CLIPBOARD_DATA_REQUEST,
 XeCR_CLIPBOARD_DATA_DELETE,
 XeCR_CASCADING,
 XeCR_OK,
 XeCR_CANCEL,
 XeCR_APPLY,
 XeCR_NO_MATCH,
 XeCR_EXPOSE,
 XeCR_RESIZE,
 XeCR_INPUT,
 XeCR_GAIN_PRIMARY,
 XeCR_LOSE_PRIMARY,
 XeCR_CREATE,
 XeCR_TEAR_OFF_ACTIVATE,
 XeCR_TEAR_OFF_DEACTIVATE,
 XeCR_OBSCURED_TRAVERSAL,
 XeCR_PROTOCOLS,
 XeCR_ACTIVATE_OPTIONS
};


// Callback structures
//
typedef struct
{
 int		reason;
 XEvent*	event;
} XeAnyCallbackStruct;


// Direction (also used for menu posting via: 'PostMenuTo')
//
enum
{
 XeLEFT=0,
 XeRIGHT,
 XeUP,
 XeDOWN,
 XeACTIVE_MENU_BUTTON	// Used with OptionMenus
};

#define XeARROW_LEFT	XeLEFT
#define XeARROW_RIGHT	XeRIGHT
#define XeARROW_UP	XeUP
#define XeARROW_DOWN	XeDOWN

// Orientation
//
enum { XeHORIZONTAL=0, XeVERTICAL };

// Placements
//
enum { XeBEFORE_SCALE=0, XeAFTER_SCALE, XeAROUND_SCALE, XeBEFORE_TEXTFIELD, XeAFTER_TEXTFIELD };

// Redraw policies
//
enum { XeREDRAW_ALL=0, XeREDRAW_CACHE_LABEL, XeREDRAW_CACHE_ALL };

// Value types
//
enum { XeINT=0, XeDOUBLE };


// Child type defines for Xe...GetChild()
//
enum
{
 XeDIALOG_NONE,			XeDIALOG_APPLY_BUTTON,
 XeDIALOG_CANCEL_BUTTON,	XeDIALOG_DEFAULT_BUTTON,
 XeDIALOG_OK_BUTTON,		XeDIALOG_FILTER_LABEL,
 XeDIALOG_FILTER_TEXT,		XeDIALOG_HELP_BUTTON,
 XeDIALOG_LIST,			XeDIALOG_LIST_LABEL,
 XeDIALOG_MESSAGE_LABEL,	XeDIALOG_SELECTION_LABEL,
 XeDIALOG_SYMBOL_LABEL,		XeDIALOG_TEXT,
 XeDIALOG_SEPARATOR,		XeDIALOG_DIR_LIST,
 XeDIALOG_DIR_LIST_LABEL,
 XeOPTION_LABEL
};



#define XeINVALID_DIMENSION	0

enum
{
 XeATTACH_NONE,
 XeATTACH_FORM,
 XeATTACH_OPPOSITE_FORM,
 XeATTACH_WIDGET,
 XeATTACH_OPPOSITE_WIDGET,
 XeATTACH_POSITION,
 XeATTACH_SELF
};


// Layout method option codes
//
enum
{
 XeINITIALIZE=0,	// Called from the initialize method
 XeRESIZE,		// Called from the resize method
 XeSET_VALUES,		// Called from the set_values method
 XeSET_CHILDREN,
 XeMOVE_CHILDREN,
 XeCONFIGURE_ME,
 XeTEST
};

// Mouse dragging modes NONE, BUTTON1, BUTTON2, BUTTON3
//
enum { XeDRAG_NONE=0, XeDRAG_BUTTON1, XeDRAG_BUTTON2, XeDRAG_BUTTON3 };


/*----------------------------------------------------------------------*/
/* Compound strings							*/
/*----------------------------------------------------------------------*/


/*==============================================================*/
/* Defines for resources to be defaulted by vendors.		*/
/* String are initialized in Xeos.c				*/
/*==============================================================*/

/*
#define	XeSTRING_OS_CHARSET		XeSTRING_ISO8859_1
#ifndef	XeFALLBACK_CHARSET
#define	XeFALLBACK_CHARSET		XeSTRING_ISO8859_1
#endif

#define XeDEFAULT_FONT                  _XeSDEFAULT_FONT
#define XeDEFAULT_BACKGROUND            _XeSDEFAULT_BACKGROUND
#define XeDEFAULT_DARK_THRESHOLD        15
#define XeDEFAULT_LIGHT_THRESHOLD       77
#define XeDEFAULT_FOREGROUND_THRESHOLD  35

externalref  char    _XeSDEFAULT_FONT[];            @* In Xeos.c @/
externalref  char    _XeSDEFAULT_BACKGROUND[];      @* In Xeos.c @/
*/

typedef unsigned char	XeDirection;


#define XeDIRECTION_IGNORED            0x30

#define XeRIGHT_TO_LEFT_MASK           0x01	// 0x01 for bc
#define XeLEFT_TO_RIGHT_MASK           0x02
#define XeHORIZONTAL_MASK              0x03
#define XeTOP_TO_BOTTOM_MASK           0x04
#define XeBOTTOM_TO_TOP_MASK           0x08
#define XeVERTICAL_MASK                0x0c
#define XePRECEDENCE_HORIZ_MASK        0x40
#define XePRECEDENCE_VERT_MASK         0x80
#define XePRECEDENCE_MASK              0xc0

enum
{
 XeRIGHT_TO_LEFT_TOP_TO_BOTTOM = XeRIGHT_TO_LEFT_MASK | XeTOP_TO_BOTTOM_MASK | XePRECEDENCE_HORIZ_MASK,
 XeLEFT_TO_RIGHT_TOP_TO_BOTTOM = XeLEFT_TO_RIGHT_MASK | XeTOP_TO_BOTTOM_MASK | XePRECEDENCE_HORIZ_MASK,
 XeRIGHT_TO_LEFT_BOTTOM_TO_TOP = XeRIGHT_TO_LEFT_MASK | XeBOTTOM_TO_TOP_MASK | XePRECEDENCE_HORIZ_MASK,
 XeLEFT_TO_RIGHT_BOTTOM_TO_TOP = XeLEFT_TO_RIGHT_MASK | XeBOTTOM_TO_TOP_MASK | XePRECEDENCE_HORIZ_MASK,
 XeTOP_TO_BOTTOM_RIGHT_TO_LEFT = XeRIGHT_TO_LEFT_MASK | XeTOP_TO_BOTTOM_MASK | XePRECEDENCE_VERT_MASK,
 XeTOP_TO_BOTTOM_LEFT_TO_RIGHT = XeLEFT_TO_RIGHT_MASK | XeTOP_TO_BOTTOM_MASK | XePRECEDENCE_VERT_MASK,
 XeBOTTOM_TO_TOP_RIGHT_TO_LEFT = XeRIGHT_TO_LEFT_MASK | XeBOTTOM_TO_TOP_MASK | XePRECEDENCE_VERT_MASK,
 XeBOTTOM_TO_TOP_LEFT_TO_RIGHT = XeLEFT_TO_RIGHT_MASK | XeBOTTOM_TO_TOP_MASK | XePRECEDENCE_VERT_MASK,
 XeTOP_TO_BOTTOM = XeTOP_TO_BOTTOM_MASK | XeHORIZONTAL_MASK | XePRECEDENCE_MASK,
 XeBOTTOM_TO_TOP = XeBOTTOM_TO_TOP_MASK | XeHORIZONTAL_MASK | XePRECEDENCE_MASK,
 XeRIGHT_TO_LEFT = XeRIGHT_TO_LEFT_MASK | XeVERTICAL_MASK | XePRECEDENCE_MASK,
 XeLEFT_TO_RIGHT = XeLEFT_TO_RIGHT_MASK | XeVERTICAL_MASK | XePRECEDENCE_MASK,
 XeDEFAULT_DIRECTION = 0xff
};


extern Boolean XeDirectionMatch(XeDirection d1, XeDirection d2);

extern Boolean XeDirectionMatchPartial(XeDirection d1, XeDirection d2, XeDirection dmask);


typedef unsigned char	XeStringDirection;
typedef unsigned char	XeChar;			// Opaque to outside
typedef unsigned short	XeWChar;		// Opaque to outside
typedef unsigned char*	XeString;		// Opaque to outside
typedef XeString*	XeStringTable;		// Opaque to outside
typedef char*		XeStringCharSet;	// NULL terminated string
typedef unsigned char	XeStringComponentType;	// Component tags

// Tag codes:
//
#define XeSTRING_COMPONENT_MAGIC0	0xDF
#define XeSTRING_COMPONENT_MAGIC1	0x80
enum
{
 XeSTRING_COMPONENT_UNKNOWN,
 XeSTRING_COMPONENT_CHARSET,
 XeSTRING_COMPONENT_TEXT,
 XeSTRING_COMPONENT_DIRECTION,
 XeSTRING_COMPONENT_SEPARATOR,
 XeSTRING_COMPONENT_LOCALE_TEXT,
 XeSTRING_COMPONENT_FULL_LENGTH,
 XeSTRING_COMPONENT_COLOR_NAME,
 XeSTRING_COMPONENT_COLOR_INDEX8,
 XeSTRING_COMPONENT_COLOR_INDEX16,
 XeSTRING_COMPONENT_COLOR_INDEX32,
 XeSTRING_COMPONENT_COLOR_RGB,
 XeSTRING_COMPONENT_COLOR_RGBA,
 XeSTRING_COMPONENT_ALIGN
};

// Codes 12-125 are reserved

#define XeSTRING_COMPONENT_END		((XeStringComponentType)126)

// Codes 128-255 are user tags
#define XeSTRING_COMPONENT_USER_BEGIN	((XeStringComponentType)128)
#define XeSTRING_COMPONENT_USER_END	((XeStringComponentType)255)



#define XeSTRING_DEFAULT_TAG		NULL

enum { XeCOL_DEFAULT=0, XeCOL_IDX8, XeCOL_IDX16, XeCOL_IDX32, XeCOL_RGB, XeCOL_RGBA };

#define XeCS_ESC	0x27

typedef struct _XeFontListEntryRec
{
 char*				Tag;
 XFontStruct*			Font;
 XFontSet*			FontSet;
 struct _XeFontListEntryRec*	Next;
 struct _XeFontListEntryRec*	Prev;
} _XeFontListEntryRec;


typedef _XeFontListEntryRec*	XeFontListEntry;	// Opaque to outside
typedef _XeFontListEntryRec*	XeFontList;		// Opaque to outside




typedef struct XeStringBinarySegment
{
 XFontStruct*		Font;
 XFontSet*		FontSet;
 Pixmap			XPixmap;
 EpImage*		Image;			// Each binary segment can have an image
 unsigned long		Color;
 unsigned char		Direction, Alignment,
			YAlignment;		// To the image...
 char*			String;
 Dimension		XSize, YSize;
 Boolean		Separator, SetColor, SetFont;
} XeStringBinarySegment;


typedef enum { XeFONT_IS_FONT=0, XeFONT_IS_FONTSET } XeFontType;

enum { XeSTRING_DIRECTION_L_TO_R, XeSTRING_DIRECTION_R_TO_L, XeSTRING_DIRECTION_DEFAULT=255 };
enum { XeSTRING_ALIGN_DEFAULT=0, XeSTRING_ALIGN_LEFT, XeSTRING_ALIGN_RIGHT, XeSTRING_ALIGN_CENTER, XeSTRING_ALIGN_JUSTIFY };


typedef struct __XeStringContextRec*	XeStringContext;	// Opaque to outside
typedef struct __XeStringRec*		_XeString;		// Opaque to outside
typedef struct _XetStringContextRec*	_XeStringContext;	// Opaque to outside
typedef struct _XeFontListContextRec*	XeFontContext;		// Opaque to outside



/*----------------------------------------------------------------------*/
/* Keyboard traversal stuff						*/
/*----------------------------------------------------------------------*/
typedef enum
{
 XeTRAVERSE_CURRENT,
 XeTRAVERSE_NEXT,
 XeTRAVERSE_PREV,
 XeTRAVERSE_HOME,
 XeTRAVERSE_NEXT_TAB_GROUP,
 XeTRAVERSE_PREV_TAB_GROUP,
 XeTRAVERSE_UP,
 XeTRAVERSE_DOWN,
 XeTRAVERSE_LEFT,
 XeTRAVERSE_RIGHT
} XeTraversalDirection;

// Keyboard focus policies for VendorShell
//
enum { XeEXPLICIT, XePOINTER };

typedef unsigned char XeNavigationType;

/*----------------------------------------------------------------------*/



/*----------------------------------------------------------------------*/
/* XeText and XeTextField related stuff					*/
/*----------------------------------------------------------------------*/
enum { XeMULTI_LINE_EDIT, XeSINGLE_LINE_EDIT };

// Text directions (for search)
//
typedef enum { XeTEXT_FORWARD, XeTEXT_BACKWARD } XeTextDirection;

typedef long	XeTextPosition;
typedef Atom	XeTextFormat;

#define XeFMT_8_BIT	((XeTextFormat) XA_STRING)
#define XeFMT_16_BIT	((XeTextFormat) 2)	// they _mean_ XA_SECONDARY ???

typedef enum
{
 XeSELECT_POSITION,
 XeSELECT_WHITESPACE,
 XeSELECT_WORD,
 XeSELECT_LINE,
 XeSELECT_ALL,
 XeSELECT_PARAGRAPH,
 XeSELECT_OUT_LINE
} XeTextScanType;

// Highlight modes
//
typedef enum
{
 XeHIGHLIGHT_NORMAL,
 XeHIGHLIGHT_SELECTED,
 XeHIGHLIGHT_SECONDARY_SELECTED
} XeHighlightMode;


typedef struct
{
 char*		ptr;
 int		length;
 XeTextFormat	format;
} XeTextBlockRec, *XeTextBlock;


typedef struct
{
 int		reason;   
 XEvent*	event;
 Boolean	doit;
 XeTextPosition	currInsert,newInsert;
 XeTextPosition	startPos,endPos;
 XeTextBlock	text;
} XeTextVerifyCallbackStruct, *XeTextVerifyPtr;


#define XeCOPY_FAILED           0
#define XeCOPY_SUCCEEDED        1
#define XeCOPY_TRUNCATED        2

typedef struct
{
 Widget		W;
 Dimension	XSize;
} XeIndentRec;



enum
{
 XeSTATIC,
 XeDYNAMIC
};

// Cursor types for XeTextField and XeText
enum
{
 XeIBEAM,
 XeSOLID
};



/*------------------------------*/
/* Macro functions		*/
/*------------------------------*/
#define XeM_AddXPoint(Points, Counter, X, Y)		Points[Counter].x=X, Points[Counter].y=Y, Counter++



/*------------------------------*/
/* Function prototypes		*/
/*------------------------------*/
extern Cursor		XeGetGrabCursor(Display* LDisplay);
extern XFontStruct*	XeScreenGetDefaultFont(Screen* LScreen);
extern double		XeActiveColorFactor, XeArmColorFactor, XeButtonColorFactor,
			XeTopShadowFactor, XeTopShadow2Factor, XeBottomShadowFactor, XeBottomShadow2Factor,
			XeGapColorFactor,
			XeTroughColorFactor;

extern Pixel		XeGetColorShade(Display* LDisplay, Colormap LColormap, Pixel LPixel, double LBrightnessFactor);
extern void		XeDrawRectangle(Display* LDisplay, Drawable LDrawable, GC LGC, Position LX, Position LY, Dimension LXSize, Dimension LYSize, Dimension LThickness);
extern void		XeDrawShadows(Display* LDisplay, Drawable LDrawable, GC LGC, Position LX, Position LY, Dimension LXSize, Dimension LYSize, Dimension LGapWidth, Pixel LGapColor, Dimension LThickness, int LType, Pixel LBackground, Pixel LTopColor, Pixel LBottomColor);
extern void		XeDrawShadows2(Display* LDisplay, Drawable LDrawable, GC LGC, Position LX, Position LY, Dimension LXSize, Dimension LYSize, Dimension LGapWidth, Pixel LGapColor, Dimension LThickness, int LType, Pixel LBackground, Pixel LTopColor, Pixel LTopColor2, Pixel LBottomColor, Pixel LBottomColor2);

extern Pixel		XeGetBackgroundColor(Display* LDisplay, Colormap LCMap);
extern Pixel		XeGetForegroundColor(Display* LDisplay, Colormap LCMap, Pixel LBackground);
extern Pixel		XeGetActiveColor(Display* LDisplay, Colormap LCMap, Pixel LBackground);
extern Pixel		XeGetTopShadowColor(Display* LDisplay, Colormap LCMap, Pixel LBackground);
extern Pixel		XeGetBottomShadowColor(Display* LDisplay, Colormap LCMap, Pixel LBackground);

extern void		XeWarning(Widget LW, char* LMessage);
extern int		XeConvertUnits(Widget widget, int orientation, int from_unit_type, int from_value, int to_unit_type);


extern XtGeometryResult	_XeMakeGeometryRequest(Widget LW, XtWidgetGeometry* LDesired);
extern int		_XeNumOfManagedChildren(Widget LW);


// From FontList.c
//
extern XeFontListEntry	XeFontListEntryCreate(char* LTag, XeFontType LType, XtPointer LFont);
extern void		XeFontListEntryFree(XeFontListEntry LEntry);
extern XeFontList	XeFontListCreate(XFontStruct* LFont, char* LTag);
extern void		XeFontListFree(XeFontList LFontList);
extern XeFontList	XeFontListAppendEntry(XeFontList LFontList, XeFontListEntry LEntry);
extern XeFontList	XeFontListAppendOneEntry(XeFontList LFontList, char* LTag, XeFontType LType, XtPointer LFont, Boolean LFreeEntry);
extern XeFontListEntry	XeFontListGetDefaultEntry(XeFontList LFontList);
extern XeFontListEntry	XeFontListGetEntryWithTag(XeFontList LFontList, char* LTag);
//---------------------------------------------------------------------------------------------------------

extern Boolean		XeStrsEqual(register char* LString0, register char* LString1);
extern char*		XeStrDup(char* LStr);

extern Boolean		XeStringDump(XeString LXeStr, Boolean LRaw);
extern Boolean		XeStringGetLtoR(XeString LXeStr, XeStringCharSet LTag, char** LText);
extern int		XeStringLength(XeString LXeStr);
extern XeString		XeStringCopy(XeString LXeStr);
extern XeString		XeStringConcat(XeString LXeStr1, XeString LXeStr2);
extern XeString		XeStringCreateSimple(char* LText);
extern XeString		XeStringCreate(char* LString, char* LTag);
extern XeString		XeStringVaCreate(Boolean LEntersToSeparators, ...);
extern void		XeStringFree(XeString LXeStr);
extern void		XeStringExtent(XeFontList LFontList, XeString LXeStr, Dimension* LXSize, Dimension* LYSize);

extern int		XeStringConvertToBinary(XeFontList LFontList, XeString LXeStr, XeStringBinarySegment** LSegmentsRet, Display* LDisplay, Colormap LColormap);
extern void		XeStringBinaryDump(XeStringBinarySegment* LSegments, int LNumOfSegments);
extern void		XeStringBinaryFree(XeStringBinarySegment* LSegments, int LNumOfSegments);
extern void		XeStringBinaryExtent(XeStringBinarySegment* LSegments, int LNumOfSegments, Dimension* LXSizeRet, Dimension* LYSizeRet);
extern Boolean		XeStringBinaryEqual(XeStringBinarySegment* LBinaryString0, unsigned long LSegmentsInString0, XeStringBinarySegment* LBinaryString1, unsigned long LSegmentsInString1);

extern void		XeStringBinaryDraw(Display* LDisplay, Drawable LDrawable, GC LGC, Boolean LUseColorsInString, Position LX, Position LY, Dimension LFullXSize, XeStringBinarySegment* LSegments, int LNumOfSegments, int LAlignment);

extern Pixel		XeGetNamedColor(Display* LDisplay, Colormap LColormap, char* LColorName);
extern Pixel		XeGetRGBColor(Display* LDisplay, Colormap LColormap, unsigned int LR, unsigned int LG, unsigned int LB);

extern void		XeBubbleHelpTimer(XtPointer LClientData, XtIntervalId* LTID);
extern void		XePopupBubbleHelp(Widget LW);
extern void		XePopdownBubbleHelp(Widget LW);


extern Boolean		XeProcessTraversal(Widget LW, XeTraversalDirection LDirection);
extern Boolean		XeHasFocus(Widget LW);

extern void		XeRingTraversal(Widget* LTWs, int LTrN);


extern void		XeSync(Widget LW);

extern void		XeDrawGrip(Display* LDisplay, Drawable LDrawable, GC LGC, Position LX, Position LY, Dimension LXSize, Dimension LYSize, Pixel LHColor, Pixel LDColor);

extern void		XeIndentWidgetsFromLeft(Widget* LWidgets, int LNumOfWidgets, Position LOffset);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}  // Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _Xe_h
