/*======================================================================*/
/* 'Xe' ERIDANI widget set						*/
/*									*/
/* Main private header file						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-07 22:37:02					*/
/*									*/
/* Xe(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _XeP_h
#define _XeP_h
#include <Xe/XeStrDefs.h>

#include <Xe/Xe.h>

#ifdef _XeUSEXm		// FIXME For now use Motif for a few things
#include <Xm/XmP.h>	// ...
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


/*
#ifdef XeDEVELOPMENT
#define XeDEBUG(p)	p
#else
#define XeDEBUG(p)
#endif
*/


#ifndef XtWidth

#define XtWidth(w)	 (((Widget)(w))->core.width)
#define XtHeight(w)	 (((Widget)(w))->core.height)
#define XtX(w)		 (((Widget)(w))->core.x)
#define XtY(w)		 (((Widget)(w))->core.y)
#define XtBackground(w)	 (((Widget)(w))->core.background_pixel)
#define XtBorderWidth(w) (((Widget)(w))->core.border_width)
#define XtSensitive(w)	 (((Widget)(w))->core.sensitive && \
			  ((Widget)(w))->core.ancestor_sensitive)
#define XtCoreProc(w,p)  (((Widget)(w))->core.widget_class->core_class.p)

#endif // XtWidth


#define ASSIGN_MAX(x, y)	if ((y) > (x)) x = (y)


// XeScale and XeScrollbar pointer locations 
//
enum { XeOUTSIDE=0, XeON_SCALE, XeON_SLIDER };

// NumObject and Scrollbar redraw flags
//
#define XeDO_VALUES		1		// Recompute pixel positions of slider/thermometer
#define XeDO_SCALE		(1<<1)		// Redraw scale background
#define XeDO_SLIDER		(1<<2)		// Redraw the slider
#define XeDO_THERMOMETER	(1<<3)		// Redraw the thermometer


// From Traversal.c
//
extern void	_XeNavigChangeManaged(Widget LW);

// Fast subclassing definitions
//
enum
{
 XeFORM_BIT=1
};

typedef struct
{
 int	process_type;
} XeParentProcessAnyRec;

typedef struct
{
 int		process_type;
 XEvent*	event;
 int		action;
 String*	params;
 Cardinal*	num_params;
} XeParentInputActionRec;

typedef union
{
 XeParentProcessAnyRec	any;
 XeParentInputActionRec	input_action;
} XeParentProcessDataRec,*XeParentProcessData;

typedef Boolean (*XeParentProcessProc)(Widget,XeParentProcessData);

#define XeInheritParentProcess     ((XmParentProcessProc) _XtInherit)

// Synthetic resource stuff
//

//FIXME as long as we need to use Motif

#ifdef _XeUSEXm

#define XeSYNTHETIC_NONE	XmSYNTHETIC_NONE
#define XeSYNTHETIC_LOAD	XmSYNTHETIC_LOAD 
#define XeSyntheticResource	XmSyntheticResource
#define XeImportOperator	XmImportOperator

#else

typedef enum
{ 
 XeSYNTHETIC_NONE, 
 XeSYNTHETIC_LOAD 
} XeImportOperator;

typedef void (*XeExportProc)(Widget,int,XtArgVal*);
typedef XeImportOperator (*XeImportProc)(Widget,int,XtArgVal*);


typedef struct _XeSyntheticResource
{
 String		resource_name;
 Cardinal	resource_size;
 Cardinal	resource_offset;
 XeExportProc	export_proc;
 XeImportProc	import_proc;
} XeSyntheticResource;

#endif // _XeUSEXm




XeImportOperator	_XeToHorizontalPixels(Widget widget,int offset,XtArgVal* value);
XeImportOperator	XeeToHorizontalPixels(Widget widget,int offset,XtArgVal* value);
XeImportOperator	_XeToVerticalPixels(Widget widget,int offset,XtArgVal* value);
XeImportOperator	XeeToVerticalPixels(Widget widget,int offset,XtArgVal* value);
void			_XeFromHorizontalPixels(Widget widget,int offset,XtArgVal* value);
void			XeeFromHorizontalPixels(Widget widget,int offset,XtArgVal* value);
void			_XeFromVerticalPixels(Widget widget,int offset,XtArgVal* value);
void			XeeFromVerticalPixels(Widget widget,int offset,XtArgVal* value);


/*----------------------------------------------------------------------*/
/* Keyboard traversal stuff						*/
/*----------------------------------------------------------------------*/
typedef enum
{
 XeFOCUS_IN,
 XeFOCUS_OUT,
 XeENTER,
 XeLEAVE
} XeFocusChange;

typedef struct _XeFocusMovedCallbackStruct
{
 int		reason;
 XEvent*	event;
 Boolean	cont;
 Widget		old_focus,new_focus;
 unsigned char	focus_policy;
} XeFocusMovedCallbackStruct, *XeFocusMovedCallback;

#define XeFOCUS_RESET   	1
#define XeFOCUS_IGNORE		2

typedef enum
{
 XeNO_RELATION,
 XeUNCLE,
 XeNEPHEW,
 XeCOUSIN,
 XeME
} XeRelations;


extern void	_XeManagerEnter(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);
extern void	_XeManagerLeave(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);
extern void	_XeManagerFocusIn(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);
extern void	_XeManagerFocusOut(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);
extern void	_XeManagerParentActivate(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);
extern void	_XeManagerParentCancel(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);
/*----------------------------------------------------------------------*/


/*----------------------------------------------------------------------*/
/* XeText and XeTextField related stuff					*/
/*----------------------------------------------------------------------*/
typedef struct
{
 XeTextPosition		position;
 XeHighlightMode	mode;
} _XeHighlightRec;

typedef struct
{
 Cardinal		number;
 Cardinal		maximum;
 _XeHighlightRec*	list;
} _XeHighlightData;
/*----------------------------------------------------------------------*/


/*======================================================*/
/* Macro to redraw keyboard focus indicator shadows	*/
/*======================================================*/
#define _XeM_DrawFocusShadows(Md,Mo)\
{\
 if(LEW->xePrimitive.HasKeyboardFocus) XeDrawShadows(LDisplay, Md, LGC, Mo, Mo, LEW->core.width-(Mo)*2, LEW->core.height-(Mo)*2, 0, LEW->xePrimitive.BottomShadowColor, LEW->xePrimitive.HighlightThickness, XeSHADOW_IN|LShadowSpecFlags, LEW->core.background_pixel, LEW->xePrimitive.TopShadowColor, LEW->xePrimitive.BottomShadowColor);\
}


extern char	_XeStrNormalColor[];
extern char	_XeStrRed[];
extern char	_XeStrGreen[];
extern char	_XeStrYellow[];
extern char	_XeStrPurple[];
extern char	_XeStrCyan[];

extern char*	_XeGetNormalColorCode(char* LPtr);
extern char*	_XeGetErrorColorCode(char* LPtr);
extern char*	_XeGetWarningColorCode(char* LPtr);
extern char*	_XeGetDirColorCode(char* LPtr);


extern Atom	_XeAtom_CLIPBOARD, _XeAtom_TARGETS;

extern void	XeInitialize(Display* LDisplay);


extern void	XeDrawArrow(Display* LDisplay, Drawable LDrw, GC LTopGC, GC LBottomGC, GC LFillGC, Position x, Position y,Dimension LXSize, Dimension LYSize, Dimension LShadowThickness, unsigned char LDirection);

extern void	_XeCastShadow(Widget LW, Position LRXPos, Position LRYPos, Dimension LMXSize, Dimension LMYSize, Window* LShadowBWindowPtr, Window* LShadowRWindowPtr, Pixmap* LShadowBMaskPtr, Pixmap* LShadowRMaskPtr, int LShadowOffset);

extern void	_XeClearShadowType(Widget w, Dimension old_width, Dimension old_height, Dimension old_shadow_thickness, Dimension old_highlight_thickness );



extern void	_XeTraverse(Widget LW, XEvent* LXEv, String* LP, Cardinal* LNP);


/*------------------------------*/
/* Debug			*/
/*------------------------------*/
extern char*	XeDBWidgetGeometryToString(XtWidgetGeometry LWG);
extern char*	XeDBGeometryReplyToString(XtGeometryResult LA);
extern int	_XeWarning(Widget LW,char* LString,...);
extern int	_XeError(Widget LW,char* LString,...);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif


#endif // _XeP_h
