/*==============================================================================*/
/* Xe Widget set								*/
/*										*/
/* String definitions								*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	1996-Oct-05 23:32:16						*/
/*										*/
/* Xe(TM) Widget set Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*==============================================================================*/
#ifndef _XeStrDefs_h
#define _XeStrDefs_h

#ifdef _XeUSEXm
#include <Xm/Xm.h>
#endif

extern char	XeResourceNames[];


/*--------------------------------------------------------------*/
/* Resource classes						*/
/*--------------------------------------------------------------*/
#define XeCArray			"Array"
#define XeCAttachment			"Attachment"
#define XeCBehavior			"Flag"
#define XeCBoolean			"Boolean"
#define XeCBorderWidth			XtCBorderWidth
#define XeCCallback			"Callback"
#define XeCColor			"Color"
#define XeCColormap			"Colormap"
#define XeCColorTable			"ColorTable"
#define XeCCount			"Count"
#define XeCDepth			"Depth"
#define XeCDirection			"Direction"
#define XeCFlag				"Flag"
#define XeCFont				"Font"
#define XeCFontList			"FontList"
#define XeCFunction			"Function"
#define XeCInitialFocus			"InitialFocus"
#define XeCLabelPixmap			"LabelPixmap"
#define XeCLabelString			"LabelString"
#define XeCList				"List"
#define XeCMargin			"Margin"
#define XeCMaxValue			"MaxValue"
#define XeCMinValue			"MinValue"
#define XeCMenuWidget			"MenuWidget"
#define XeCOffset			"Offset"
#define XeCOrientation			"Orientation"
#define XeCPixmap			XtCPixmap
#define XeCPlacement			"Placement"
#define XeCPointer			"Pointer"
#define XeCPolicy			"Policy"
#define XeCPosition			"Position"
#define XeCResizePolicy			"ResizePolicy"
#define XeCShadowType			"Flag"
#define XeCSize				"Size"
#define XeCSpacing			"Spacing"
#define XeCString			"String"
#define XeCTime				"Time"
#define XeCType				"Type"
#define XeCValue			"Value"
#define XeCVisualInfo			"VisualInfo"
#define XeCVisual			"Visual"
#define XeCWidget			XtRWidget
#define XeCWindow			"Window"

/*--------------------------------------------------------------*/
/* Resource types						*/
/*--------------------------------------------------------------*/
#define XeRAlignment			"unsigned char"
#define XeRAttachment			"unsigned char"
#define XeRBehavior			"unsigned char"
#define XeRBoolean			XtRBoolean
#define XeRCallback			XtRCallback
#define XeRChar				"char"
#define XeRDimension			XtRDimension
#define XeRDirection			"unsigned char"
#define XeRFont				"XFontStruct*"
#define XeRFontList			"XeFontList"
#define XeRFunction			"void*"
#define XeRInt				XtRInt
#define XeRIntPointer			"int*"
#define XeRLabelType			"unsigned char"
#define XeRPixel			XtRPixel
#define XeRPixelPointer			"Pixel*"
#define XeRPixmap			XtRPixmap
#define XeRPointer			XtRPointer
#define XeRPolicy			"Policy"
#define XeRShadowType			"unsigned int"
#define XeRString			"char*"
#define XeRUnsignedChar			XtRUnsignedChar
#define XeRVisualInfo			"VisualInfo"
#define XeRWidget			XtRWidget
#define XeRXeString			"XeString"

/*----------------------------------------------------------------------*/
/* Resource names							*/
/* This list is automatically generated, do not modify it!		*/
/*----------------------------------------------------------------------*/
#define XeNaccelerator				((char*)(&XeResourceNames[0]))
#define XeNacceleratorText			((char*)(&XeResourceNames[12]))
#define XeNactivateCallback			((char*)(&XeResourceNames[28]))
#define XeNactivateOnArm			((char*)(&XeResourceNames[45]))
#define XeNactivateOnLeave			((char*)(&XeResourceNames[59]))
#define XeNactivateOnTextChange			((char*)(&XeResourceNames[75]))
#define XeNactiveColor				((char*)(&XeResourceNames[96]))
#define XeNactiveImage				((char*)(&XeResourceNames[108]))
#define XeNactivePixmap				((char*)(&XeResourceNames[120]))
#define XeNactivePixmapMask			((char*)(&XeResourceNames[133]))
#define XeNadjustLast				((char*)(&XeResourceNames[150]))
#define XeNadjustEntryWidths			((char*)(&XeResourceNames[161]))
#define XeNadjustEntryHeights			((char*)(&XeResourceNames[179]))
#define XeNalignOffset				((char*)(&XeResourceNames[198]))
#define XeNalignTo				((char*)(&XeResourceNames[210]))
#define XeNalive				((char*)(&XeResourceNames[218]))
#define XeNarmCallback				((char*)(&XeResourceNames[224]))
#define XeNarmColor				((char*)(&XeResourceNames[236]))
#define XeNarmImage				((char*)(&XeResourceNames[245]))
#define XeNarmPixmap				((char*)(&XeResourceNames[254]))
#define XeNarmPixmapMask			((char*)(&XeResourceNames[264]))
#define XeNarrowArmColor			((char*)(&XeResourceNames[278]))
#define XeNarrowActiveColor			((char*)(&XeResourceNames[292]))
#define XeNarrowBehavior			((char*)(&XeResourceNames[309]))
#define XeNarrowDirection			((char*)(&XeResourceNames[323]))
#define XeNarrowShadowThickness			((char*)(&XeResourceNames[338]))
#define XeNbackgroundColor			((char*)(&XeResourceNames[359]))
#define XeNblinkRate				((char*)(&XeResourceNames[375]))
#define XeNbottomShadowColor			((char*)(&XeResourceNames[385]))
#define XeNbrowseSelectionCallback		((char*)(&XeResourceNames[406]))
#define XeNbuttonColor				((char*)(&XeResourceNames[430]))
#define XeNbuttonPlacement			((char*)(&XeResourceNames[442]))
#define XeNbuttonSpacing			((char*)(&XeResourceNames[458]))
#define XeNbuttonType				((char*)(&XeResourceNames[472]))
#define XeNcancelCallback			((char*)(&XeResourceNames[483]))
#define XeNcascadeMarginHeight			((char*)(&XeResourceNames[498]))
#define XeNcastShadowWidth			((char*)(&XeResourceNames[518]))
#define XeNcheckMarkOn				((char*)(&XeResourceNames[534]))
#define XeNcheckMarkColor			((char*)(&XeResourceNames[546]))
#define XeNclearBackground			((char*)(&XeResourceNames[561]))
#define XeNcolormap				((char*)(&XeResourceNames[577]))
#define XeNcolumns				((char*)(&XeResourceNames[586]))
#define XeNcorrectOnLeave			((char*)(&XeResourceNames[594]))
#define XeNcreateDownButton			((char*)(&XeResourceNames[609]))
#define XeNcreateLabel				((char*)(&XeResourceNames[626]))
#define XeNcreateOptionsButton			((char*)(&XeResourceNames[638]))
#define XeNcreateResetButton			((char*)(&XeResourceNames[658]))
#define XeNcreateScale				((char*)(&XeResourceNames[676]))
#define XeNcreateTextField			((char*)(&XeResourceNames[688]))
#define XeNcreateUpButton			((char*)(&XeResourceNames[704]))
#define XeNcursorColor				((char*)(&XeResourceNames[719]))
#define XeNTcursorPosition			((char*)(&XeResourceNames[731]))
#define XeNTcursorPositionVisible		((char*)(&XeResourceNames[750]))
#define XeNcursorType				((char*)(&XeResourceNames[776]))
#define XeNdecimalPoints			((char*)(&XeResourceNames[790]))
#define XeNdefaultActionCallback		((char*)(&XeResourceNames[804]))
#define XeNdefaultButton			((char*)(&XeResourceNames[826]))
#define XeNdefaultButtonShadowThickness		((char*)(&XeResourceNames[840]))
#define XeNdirection				((char*)(&XeResourceNames[869]))
#define XeNdisarmCallback			((char*)(&XeResourceNames[879]))
#define XeNdragCallback				((char*)(&XeResourceNames[894]))
#define XeNeditable				((char*)(&XeResourceNames[907]))
#define XeNentryAlignment			((char*)(&XeResourceNames[916]))
#define XeNentryXAlignment			((char*)(&XeResourceNames[931]))
#define XeNentryYAlignment			((char*)(&XeResourceNames[947]))
#define XeNextendedSelectionCallback		((char*)(&XeResourceNames[963]))
#define XeNfolderWidget				((char*)(&XeResourceNames[989]))
#define XeNfillOnSelect				((char*)(&XeResourceNames[1002]))
#define XeNfont					((char*)(&XeResourceNames[1015]))
#define XeNfontList				((char*)(&XeResourceNames[1020]))
#define XeNfractionBase				((char*)(&XeResourceNames[1029]))
#define XeNgapColor				((char*)(&XeResourceNames[1042]))
#define XeNgapWidth				((char*)(&XeResourceNames[1051]))
#define XeNGC					((char*)(&XeResourceNames[1060]))
#define XeNhelpCallback				((char*)(&XeResourceNames[1063]))
#define XeNhighlightColor			((char*)(&XeResourceNames[1076]))
#define XeNhighlightImage			((char*)(&XeResourceNames[1091]))
#define XeNhighlightPixmap			((char*)(&XeResourceNames[1106]))
#define XeNhighlightPixmapMask			((char*)(&XeResourceNames[1122]))
#define XeNhighlightThickness			((char*)(&XeResourceNames[1142]))
#define XeNheightAdjustable			((char*)(&XeResourceNames[1164]))
#define XeNhorizontalScrollBar			((char*)(&XeResourceNames[1181]))
#define XeNhorizontalSpacing			((char*)(&XeResourceNames[1201]))
#define XeNincrement				((char*)(&XeResourceNames[1219]))
#define XeNindicatorColor			((char*)(&XeResourceNames[1229]))
#define XeNindicatorOn				((char*)(&XeResourceNames[1244]))
#define XeNindicatorSize			((char*)(&XeResourceNames[1256]))
#define XeNindicatorType			((char*)(&XeResourceNames[1270]))
#define XeNindicatorXSize			((char*)(&XeResourceNames[1284]))
#define XeNindicatorYSize			((char*)(&XeResourceNames[1299]))
#define XeNinitialFocus				((char*)(&XeResourceNames[1314]))
#define XeNitems				((char*)(&XeResourceNames[1327]))
#define XeNitemCount				((char*)(&XeResourceNames[1333]))
#define XeNlabelColor				((char*)(&XeResourceNames[1343]))
#define XeNlabelFontList			((char*)(&XeResourceNames[1354]))
#define XeNlabelHeight				((char*)(&XeResourceNames[1368]))
#define XeNlabelImage				((char*)(&XeResourceNames[1380]))
#define XeNlabelInsensitiveImage		((char*)(&XeResourceNames[1391]))
#define XeNlabelInsensitivePixmap		((char*)(&XeResourceNames[1413]))
#define XeNlabelInsensitivePixmapMask		((char*)(&XeResourceNames[1436]))
#define XeNlabelPixmap				((char*)(&XeResourceNames[1463]))
#define XeNlabelPixmapMask			((char*)(&XeResourceNames[1475]))
#define XeNlabelPlacement			((char*)(&XeResourceNames[1491]))
#define XeNlabelShadow				((char*)(&XeResourceNames[1506]))
#define XeNlabelType				((char*)(&XeResourceNames[1518]))
#define XeNlabelString				((char*)(&XeResourceNames[1528]))
#define XeNlabelWidth				((char*)(&XeResourceNames[1540]))
#define XeNlabelXAlignment			((char*)(&XeResourceNames[1551]))
#define XeNlabelYAlignment			((char*)(&XeResourceNames[1567]))
#define XeNlayoutProc				((char*)(&XeResourceNames[1583]))
#define XeNlistSizePolicy			((char*)(&XeResourceNames[1594]))
#define XeNmapCallback				((char*)(&XeResourceNames[1609]))
#define XeNmappingDelay				((char*)(&XeResourceNames[1621]))
#define XeNmaxXSize				((char*)(&XeResourceNames[1634]))
#define XeNmaxYSize				((char*)(&XeResourceNames[1643]))
#define XeNmaximum				((char*)(&XeResourceNames[1652]))
#define XeNmarginBottom				((char*)(&XeResourceNames[1660]))
#define XeNmarginHeight				((char*)(&XeResourceNames[1673]))
#define XeNmarginLeft				((char*)(&XeResourceNames[1686]))
#define XeNmarginRight				((char*)(&XeResourceNames[1697]))
#define XeNmarginTop				((char*)(&XeResourceNames[1709]))
#define XeNmarginWidth				((char*)(&XeResourceNames[1719]))
#define XeNmenuFontList				((char*)(&XeResourceNames[1731]))
#define XeNmenuHistory				((char*)(&XeResourceNames[1744]))
#define XeNmenuPaneBackground			((char*)(&XeResourceNames[1756]))
#define XeNminXSize				((char*)(&XeResourceNames[1775]))
#define XeNminYSize				((char*)(&XeResourceNames[1784]))
#define XeNmnemonic				((char*)(&XeResourceNames[1793]))
#define XeNminimum				((char*)(&XeResourceNames[1802]))
#define XeNmultipleSelectionCallback		((char*)(&XeResourceNames[1810]))
#define XeNnoResize				((char*)(&XeResourceNames[1836]))
#define XeNnumOfColumns				((char*)(&XeResourceNames[1845]))
#define XeNnumOfTextColors			((char*)(&XeResourceNames[1858]))
#define XeNokCallback				((char*)(&XeResourceNames[1874]))
#define XeNorientation				((char*)(&XeResourceNames[1885]))
#define XeNpacking				((char*)(&XeResourceNames[1897]))
#define XeNpixmapDepth				((char*)(&XeResourceNames[1905]))
#define XeNpostMenuTo				((char*)(&XeResourceNames[1917]))
#define XeNpreferredSizeProc			((char*)(&XeResourceNames[1928]))
#define XeNradioAlwaysOne			((char*)(&XeResourceNames[1946]))
#define XeNradioBehavior			((char*)(&XeResourceNames[1961]))
#define XeNrangeCount				((char*)(&XeResourceNames[1975]))
#define XeNrangeList				((char*)(&XeResourceNames[1986]))
#define XeNrecomputeSizeIfNotRealized		((char*)(&XeResourceNames[1996]))
#define XeNredrawPolicy				((char*)(&XeResourceNames[2023]))
#define XeNrecomputeSize			((char*)(&XeResourceNames[2036]))
#define XeNrecomputeXSize			((char*)(&XeResourceNames[2050]))
#define XeNrecomputeYSize			((char*)(&XeResourceNames[2065]))
#define XeNresetValue				((char*)(&XeResourceNames[2080]))
#define XeNresizable				((char*)(&XeResourceNames[2091]))
#define XeNresizePolicy				((char*)(&XeResourceNames[2101]))
#define XeNrows					((char*)(&XeResourceNames[2114]))
#define XeNrubberPositioning			((char*)(&XeResourceNames[2119]))
#define XeNscaleGroove				((char*)(&XeResourceNames[2137]))
#define XeNscaleLength				((char*)(&XeResourceNames[2149]))
#define XeNscaleLengthInPixels			((char*)(&XeResourceNames[2161]))
#define XeNscaleMaximum				((char*)(&XeResourceNames[2181]))
#define XeNscaleMinimum				((char*)(&XeResourceNames[2194]))
#define XeNscaleShadowThickness			((char*)(&XeResourceNames[2207]))
#define XeNscaleType				((char*)(&XeResourceNames[2228]))
#define XeNscaleWidthInPixels			((char*)(&XeResourceNames[2238]))
#define XeNscrollBarDisplayPolicy		((char*)(&XeResourceNames[2257]))
#define XeNscrollingPolicy			((char*)(&XeResourceNames[2280]))
#define XeNselectColor				((char*)(&XeResourceNames[2296]))
#define XeNselectionCallback			((char*)(&XeResourceNames[2308]))
#define XeNsensitive				((char*)(&XeResourceNames[2326]))
#define XeNset					((char*)(&XeResourceNames[2336]))
#define XeNsingleSelectionCallback		((char*)(&XeResourceNames[2340]))
#define XeNshadowThickness			((char*)(&XeResourceNames[2364]))
#define XeNshadowType				((char*)(&XeResourceNames[2383]))
#define XeNshowArrow				((char*)(&XeResourceNames[2397]))
#define XeNshowAsDefault			((char*)(&XeResourceNames[2407]))
#define XeNsliderActiveColor			((char*)(&XeResourceNames[2421]))
#define XeNsliderBorderColor			((char*)(&XeResourceNames[2439]))
#define XeNsliderBorderWidth			((char*)(&XeResourceNames[2457]))
#define XeNsliderColor				((char*)(&XeResourceNames[2475]))
#define XeNsliderLength				((char*)(&XeResourceNames[2487]))
#define XeNsliderLengthInPixels			((char*)(&XeResourceNames[2500]))
#define XeNsliderMask				((char*)(&XeResourceNames[2521]))
#define XeNsliderImage				((char*)(&XeResourceNames[2532]))
#define XeNsliderPixmap				((char*)(&XeResourceNames[2544]))
#define XeNsliderPixmapXSize			((char*)(&XeResourceNames[2557]))
#define XeNsliderPixmapYSize			((char*)(&XeResourceNames[2575]))
#define XeNsliderSize				((char*)(&XeResourceNames[2593]))
#define XeNsliderWidthInPixels			((char*)(&XeResourceNames[2604]))
#define XeNsmoothScrollSteps			((char*)(&XeResourceNames[2624]))
#define XeNsmoothScrollTimeStep			((char*)(&XeResourceNames[2642]))
#define XeNspacing				((char*)(&XeResourceNames[2663]))
#define XeNstretchButtons			((char*)(&XeResourceNames[2671]))
#define XeNsubMenuId				((char*)(&XeResourceNames[2686]))
#define XeNtextBackground			((char*)(&XeResourceNames[2696]))
#define XeNtextColors				((char*)(&XeResourceNames[2711]))
#define XeNtextFieldChangedCallback		((char*)(&XeResourceNames[2722]))
#define XeNtextFieldDigits			((char*)(&XeResourceNames[2747]))
#define XeNtextFieldFontList			((char*)(&XeResourceNames[2763]))
#define XeNtextFieldPlacement			((char*)(&XeResourceNames[2781]))
#define XeNtextFieldShadowThickness		((char*)(&XeResourceNames[2800]))
#define XeNtextFieldWidth			((char*)(&XeResourceNames[2825]))
#define XeNtextForeground			((char*)(&XeResourceNames[2840]))
#define XeNtextHighlightColor			((char*)(&XeResourceNames[2855]))
#define XeNthermoBottomShadowColor		((char*)(&XeResourceNames[2874]))
#define XeNthermoColor				((char*)(&XeResourceNames[2898]))
#define XeNthermoFlow				((char*)(&XeResourceNames[2910]))
#define XeNthermoShadowThickness		((char*)(&XeResourceNames[2921]))
#define XeNthermoTopShadowColor			((char*)(&XeResourceNames[2943]))
#define XeNtopCharacter				((char*)(&XeResourceNames[2964]))
#define XeNtopShadowColor			((char*)(&XeResourceNames[2977]))
#define XeNtroughColor				((char*)(&XeResourceNames[2995]))
#define XeNtraverseDown				((char*)(&XeResourceNames[3007]))
#define XeNtraverseLeft				((char*)(&XeResourceNames[3020]))
#define XeNtraverseRight			((char*)(&XeResourceNames[3033]))
#define XeNtraverseUp				((char*)(&XeResourceNames[3047]))
#define XeNtype					((char*)(&XeResourceNames[3058]))
#define XeNunmapCallback			((char*)(&XeResourceNames[3063]))
#define XeNuserData				((char*)(&XeResourceNames[3077]))
#define XeNvalue				((char*)(&XeResourceNames[3089]))
#define XeNvalueArray				((char*)(&XeResourceNames[3095]))
#define XeNvalueChangedCallback			((char*)(&XeResourceNames[3106]))
#define XeNvalueCount				((char*)(&XeResourceNames[3127]))
#define XeNvalueIndex				((char*)(&XeResourceNames[3138]))
#define XeNvalueType				((char*)(&XeResourceNames[3149]))
#define XeNverticalScrollBar			((char*)(&XeResourceNames[3159]))
#define XeNverticalSpacing			((char*)(&XeResourceNames[3177]))
#define XeNvisualInfo				((char*)(&XeResourceNames[3193]))
#define XeNvisibleWhenOff			((char*)(&XeResourceNames[3204]))
#define XeNwidthAdjustable			((char*)(&XeResourceNames[3219]))
#define XeNworkAreaMarginHeight			((char*)(&XeResourceNames[3235]))
#define XeNworkAreaMarginWidth			((char*)(&XeResourceNames[3256]))
#define XeNworkAreaShadowThickness		((char*)(&XeResourceNames[3276]))
#define XeNworkWindow				((char*)(&XeResourceNames[3300]))
#define XeNxAlignment				((char*)(&XeResourceNames[3311]))
#define XeNyAlignment				((char*)(&XeResourceNames[3322]))
#define XeNxSpacing				((char*)(&XeResourceNames[3333]))
#define XeNySpacing				((char*)(&XeResourceNames[3342]))
#define XeNTbottomAttachment			((char*)(&XeResourceNames[3351]))
#define XeNTbottomOffset			((char*)(&XeResourceNames[3369]))
#define XeNTbottomPosition			((char*)(&XeResourceNames[3383]))
#define XeNTbottomWidget			((char*)(&XeResourceNames[3399]))
#define XeNTleftAttachment			((char*)(&XeResourceNames[3413]))
#define XeNTleftOffset				((char*)(&XeResourceNames[3429]))
#define XeNTleftPosition			((char*)(&XeResourceNames[3441]))
#define XeNTleftWidget				((char*)(&XeResourceNames[3455]))
#define XeNTrightAttachment			((char*)(&XeResourceNames[3467]))
#define XeNTrightOffset				((char*)(&XeResourceNames[3484]))
#define XeNTrightPosition			((char*)(&XeResourceNames[3497]))
#define XeNTrightWidget				((char*)(&XeResourceNames[3512]))
#define XeNtipBackground			((char*)(&XeResourceNames[3525]))
#define XeNtipDelay				((char*)(&XeResourceNames[3539]))
#define XeNtipFontList				((char*)(&XeResourceNames[3548]))
#define XeNtipImage				((char*)(&XeResourceNames[3560]))
#define XeNtipLabelType				((char*)(&XeResourceNames[3569]))
#define XeNtipPixmap				((char*)(&XeResourceNames[3582]))
#define XeNtipString				((char*)(&XeResourceNames[3592]))
#define XeNTtopAttachment			((char*)(&XeResourceNames[3602]))
#define XeNTtopOffset				((char*)(&XeResourceNames[3617]))
#define XeNTtopPosition				((char*)(&XeResourceNames[3628]))
#define XeNTtopWidget				((char*)(&XeResourceNames[3641]))
#define XeNTmwmDecorations			((char*)(&XeResourceNames[3652]))
#define XeNvisibleItemCount			((char*)(&XeResourceNames[3668]))



#ifdef _XeUSEXm

#define XeNbottomAttachment		XmNbottomAttachment
#define XeNbottomOffset			XmNbottomOffset
#define XeNbottomPosition		XmNbottomPosition
#define XeNbottomWidget			XmNbottomWidget
#define	XeNleftAttachment		XmNleftAttachment
#define	XeNleftOffset			XmNleftOffset
#define	XeNleftPosition			XmNleftPosition
#define	XeNleftWidget			XmNleftWidget
#define XeNrightAttachment		XmNrightAttachment
#define XeNrightOffset			XmNrightOffset
#define XeNrightPosition		XmNrightPosition
#define XeNrightWidget			XmNrightWidget
#define XeNtopAttachment		XmNtopAttachment
#define XeNtopOffset			XmNtopOffset
#define XeNtopPosition			XmNtopPosition
#define XeNtopWidget			XmNtopWidget
#define XeNmwmDecorations		XmNmwmDecorations
#define XeNcursorPosition		XmNcursorPosition
#define XeNcursorPositionVisible	XmNcursorPositionVisible
#else

#define XeNbottomAttachment		XeNTbottomAttachment
#define XeNbottomOffset			XeNTbottomOffset
#define XeNbottomPosition		XeNTbottomPosition
#define XeNbottomWidget			XeNTbottomWidget
#define	XeNleftAttachment		XeNTleftAttachment
#define	XeNleftOffset			XeNTleftOffset
#define	XeNleftPosition			XeNTleftPosition
#define	XeNleftWidget			XeNTleftWidget
#define XeNrightAttachment		XeNTrightAttachment
#define XeNrightOffset			XeNTrightOffset
#define XeNrightPosition		XeNTrightPosition
#define XeNrightWidget			XeNTrightWidget
#define XeNtopAttachment		XeNTtopAttachment
#define XeNtopOffset			XeNTtopOffset
#define XeNtopPosition			XeNTtopPosition
#define XeNtopWidget			XeNTtopWidget
#define XeNmwmDecorations		XeNTmwmDecorations

#define XeNcursorPosition		XeNTcursorPosition
#define XeNcursorPositionVisible	XeNTcursorPositionVisible

#endif // _XeUSEXm



#define XeNallowShellResize		XtNallowShellResize
#define XeNbackground			XtNbackground
#define XeNborderColor			XtNborderColor
#define XeNborderWidth			XtNborderWidth
#define XeNforeground			XtNforeground
#define XeNheight			XtNheight
#define	XeNlabelXSize			XeNlabelWidth
#define	XeNlabelYSize			XeNlabelHeight
#define XeNmarginXSize			XeNmarginWidth
#define XeNmarginYSize			XeNmarginHeight
#define XeNnumChildren			XtNnumChildren
#define	XeNtextFieldXSize		XeNtextFieldWidth
#define XeNwidth			XtNwidth
#define XeNx				XtNx
#define XeNxSize			XtNwidth
#define XeNy				XtNy
#define XeNySize			XtNheight



// XeGLDraw resource names
#define XeNglxConfig			"glxConfig"
#define XeCGlxConfig			"GlxConfig"
#define XeRGlxConfig			"GlxConfig"
#define XeNoverrideColormap		"overrideColormap"
#define XeCOverrideColormap		"OverrideColormap"

#define XeNginitCallback		"ginitCallback"
#define XeNresizeCallback		"resizeCallback"

#define XeNuseOverlay			"useOverlay"
#define XeCUseOverlay			"UseOverlay"
#define XeNoverlayColormap		"overlayColormap"
#define XeNoverlayDepth			"overlayDepth"
#define XeNoverlayVisual		"overlayVisual"
#define XeNoverlayWindow		"overlayWindow"
#define XeNoverlayExposeCallback	"overlayExposeWindow"
#define XeNuseUnderlay			"useUnderlay"
#define XeCUseUnderlay			"UseUnderlay"
#define XeNunderlayColormap		"underlayColormap"
#define XeNunderlayDepth		"underlayDepth"
#define XeNunderlayVisual		"underlayVisual"
#define XeNunderlayWindow		"underlayWindow"
#define XeNunderlayExposeCallback	"underlayExposeWindow"
#define XeNusePopup			"usePopup"
#define XeCUsePopup			"UsePopup"
#define XeNpopupColormap		"popupColormap"
#define XeNpopupDepth			"popupDepth"
#define XeNpopupVisual			"popupVisual"
#define XeNpopupWindow			"popupWindow"
#define XeNpopupExposeCallback		"popupExposeWindow"


extern char	XeSFONTLIST_DEFAULT_TAG_STRING[];

#define XeS ""
#define XeSTRING_DEFAULT_CHARSET	XeS
#define XeSTRING_ISO8859_1		"ISO8859-1"
#define XeFONTLIST_DEFAULT_TAG		XeSFONTLIST_DEFAULT_TAG_STRING
#define XeFONTLIST_DEFAULT_TAG_STRING	XeSFONTLIST_DEFAULT_TAG_STRING


#endif // _XeStrDefs_h
