/*======================================================================================================*/
/* A simple plugin-skeleton for EQUINOX-3D								*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	2002-Aug-01 23:55:07									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <math.h>
#include <stdio.h>

#include <EMalloc.h>
#include <EPlugins.h>

#include <EGUI/PushButton.h>
#include <EGUI/Dialog.h>

#include <E3D/3DWindow.h>
#include <E3D/StatusPanel.h>


static EPluginRec*	_PluginRec=NULL;


static EguiItem		_MenuButton=NULL, _ToolPanelButton=NULL;

// Import the icon images that were compiled into separate object files
//
extern EpCImage		Image_Simple;
extern EpCImage		Image_SimpleActive;
extern EpCImage		Image_SimpleArm;


/*
To get EQUINOX-3D to read this plugin on startup, just add the following to
your Plugins.list file (normally found in the /usr/local/equinox/Plugins directory):

{
Name		= Simple plugin;
Object		= Simple;
}

*/



/*==============================================*/
/* Button callback function			*/
/*==============================================*/
static void _MCB(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{

// Print message in the shell
//
printf("Yey, you clicked the Simple button!\n");fflush(stdout);


// Flass a message on the StatusPanel for 5 seconds (=5000 milliseconds)
//

 E3dp_PrintMessage(0, 5000, "Yey, you clicked the Simple button!");
}


/*======================================*/
/* Entry point of the plugin		*/
/*======================================*/
int Plugin_Init(EPluginRec* LPlugin)
{
 EpImage*	LImage;
 EpImage*	LActiveImage;
 EpImage*	LArmImage;

 _PluginRec=LPlugin;

// Initialize images for the icon
// - Inactive state
// - Highlighted state (mouse-over)
// - Armed state (pushed-in)
//
 EpM_RGBA8ImageFromCStruct(LImage, Image_Simple);
 EpM_RGBA8ImageFromCStruct(LActiveImage, Image_SimpleActive);
 EpM_RGBA8ImageFromCStruct(LArmImage, Image_SimpleArm);


// Add a button to the 'Create' folder of the ToolPanel
//
 _ToolPanelButton=EGUI_AddPushButtonImg("Tool->Create", "Simple", '\0', NULL, NULL, TRUE, "This is the tool-tip", _MCB, (EPointer)0, LImage, LActiveImage, LArmImage);


// Add a button to the 'Create' menu
//
 _MenuButton=EGUI_AddPushButton("Menu->Create", "Simple", '\0', NULL, NULL, TRUE, NULL, _MCB, (EPointer)0);

 return(0);
}


/*======================================*/
/* Exit method of the plugin		*/
/*======================================*/
int Plugin_Exit()
{
// Free memory associated with the buttons
//
 if(_MenuButton) EGUI_DestroyItem(_MenuButton);
 if(_ToolPanelButton) EGUI_DestroyItem(_ToolPanelButton);

 return(0);
}
