/* Copyright (c) 1995,1996,1997 NEC Corporation.  All rights reserved.       */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: hide.h,v 1.4.4.2 1998/06/29 22:40:41 salman Exp $
 */

#if defined(FOR_SHARED_LIBRARY) && defined(HIDEORIG)

#ifndef HIDE_H
#define HIDE_H

/* Try to hide these functions so we don't get compiler pukage.              */
#define HIDE(x)       _hidden_ ## x
#define gethostbyname HIDE(gethostbyname)
#define getpeername   HIDE(getpeername)
#define getsockname   HIDE(getsockname)
#define accept        HIDE(accept)
#define connect       HIDE(connect)
#define select        HIDE(select)
#define bind          HIDE(bind)
#define recvfrom      HIDE(recvfrom)
#define sendto        HIDE(sendto)
#define recvmsg       HIDE(recvmsg)
#define sendmsg        HIDE(sendmsg)
#define recv          HIDE(recv)
#define send          HIDE(send)
#define read          HIDE(read)
#define write         HIDE(write)
#ifdef HAVE_RRESVPORT
#define rresvport     HIDE(rresvport)
#endif
#define shutdown      HIDE(shutdown)
#define listen        HIDE(listen)
#define longjmp       HIDE(longjmp)
#define close         HIDE(close)
#define flcose        HIDE(fclose)

#else

#undef HIDE_H

/* Unhide these functions so we can deal with them now that includes are     */
/* done...Hopefully...                                                       */
#undef gethostbyname 
#undef getpeername   
#undef getsockname   
#undef accept        
#undef connect       
#undef select       
#undef bind          
#undef recvfrom      
#undef sendto        
#undef recvmsg      
#undef sendmsg        
#undef recv          
#undef send          
#undef read          
#undef write         
#ifdef HAVE_RRESVPORT
#undef rresvport     
#endif
#undef shutdown      
#undef listen        
#undef longjmp        
#undef close         
#undef flcose        

#endif
#endif
