/* Copyright (c) 1995,1996,1997 NEC Corporation.  All rights reserved.       */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: s5util.h,v 1.2 1997/06/16 15:28:50 steve Exp $
 */

#ifndef S5UTIL_H
#define S5UTIL_H

#ifndef P
#ifdef __STDC__
#define P(x) x
#else
#define P(X) ()
#endif
#endif

#ifndef __NOLOGUPDATEPROTO
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#else 
#include <varargs.h>
#endif
extern void S5LogUpdate  P((const void * /* handle  */, int /* level  */, int /* entry */, const char * /* format */, ...));
extern void S5LogvUpdate P((const void * /* handle  */, int /* level  */, int /* entry */, const char * /* format */, va_list));
#endif
extern void S5LogStart   P((      void **/* handlep */, int /* how    */, int /* level */, const char * /* name   */));
extern void S5LogEnd     P((      void * /* handle  */));

/* how */
#define S5_LOG_LOCAL       0x01
#define S5_LOG_SYSTEM      0x02

/* level */
#define S5_LOG_ERROR       0x01
#define S5_LOG_INFO        0x02
#define S5_LOG_WARNING     0x03
#define S5_LOG_DEBUG_MAX   0xff
#define S5_LOG_DEBUG(x)    (0x04 + (x))

extern void *S5LogDefaultHandle;
extern int   S5LogShowThreadIDS;
#endif
