/* Copyright (c) 1995,1996,1997 NEC Corporation.  All rights reserved.       */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: threads.h,v 1.13.2.2.2.2 1998/03/04 16:13:34 jyou Exp $
 */

#ifndef MUTEX_H
#define MUTEX_H

#ifdef IN_LIBRARY
#undef USE_THREADS
#endif

#ifdef USE_THREADS
#ifdef HAVE_PTHREAD_H

#if defined(_OSF_SOURCE) && defined(HAVE_PTHREAD_ATTR_INIT)
#define _PTHREAD_ENV_CXX
#endif

#ifdef _HPUX_SOURCE
#define CMA_UX
#define cma_sigaction sigaction
#endif
#include <pthread.h>

typedef pthread_mutex_t MUTEX_T;
typedef pthread_attr_t  ATTR_T;
typedef pthread_t       THREAD_T;

/* A good guess at the default mutex initializer...                          */
#ifndef PTHREAD_MUTEX_INITIALIZER
#define PTHREAD_MUTEX_INITIALIZER { 0 } 
#endif

#ifdef HAVE_PTHREAD_ATTR_INIT
#define THREAD_ATTR_INIT(x)   pthread_attr_init(&(x))
#define THREAD_ATTR_SETSTACKSIZE(x,y)
#elif defined(_DECTHREADS_) && !defined(HAVE_PTHREAD_ATTR_INIT)
#define THREAD_ATTR_INIT(x)   pthread_attr_create(&(x))
#define THREAD_ATTR_SETSTACKSIZE(x,y) pthread_attr_setstacksize(x,y)
#else
#define THREAD_ATTR_INIT(x)
#define THREAD_ATTR_SETSTACKSIZE(x,y)
#endif
#ifdef HAVE_PTHREAD_ATTR_SCOPE
#define THREAD_ATTR_SETSCOPE(x, y)   pthread_attr_setscope(&(x), y)
#else
#define THREAD_ATTR_SETSCOPE(x,y)
#endif
#ifdef HAVE_PTHREAD_ATTR_SETDETACHSTATE
#define THREAD_ATTR_SETDETACHSTATE(x, y)   pthread_attr_setdetachstate(&(x), y)
#else
#define THREAD_ATTR_SETDETACHSTATE(x,y)
#endif

#ifdef HAVE_PTHREAD_SIGMASK
#define THREAD_SIGMASK(x, y, z)   pthread_sigmask(x, &(y), &(z))
#elif defined(_AIX)
#define THREAD_SIGMASK(x, y, z)   sigthreadmask(x, &(y), &(z))
#else
#define THREAD_SIGMASK(x, y, z)
#endif

#ifdef HAVE_PTHREAD_KILL
#define THREAD_KILL(x, y)         pthread_kill(x,y)
#else
#define THREAD_KILL(x,y)          -1
#endif

#if !defined(_DECTHREADS_) || defined(HAVE_PTHREAD_ATTR_INIT)
#define MUTEX_SETUP(x)
#else
#define MUTEX_SETUP(x)    pthread_mutex_init(&(x), pthread_mutexattr_default)
#endif

#define MUTEX_LOCK(x)     pthread_mutex_lock(&(x))
#define MUTEX_UNLOCK(x)   pthread_mutex_unlock(&(x))
#define MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER

#if !defined(_DECTHREADS_) || defined(HAVE_PTHREAD_ATTR_INIT)
#define THREAD_CREATE(x,y,z,w) pthread_create(x,&(y),z,w)
#define THREAD_DETACH(x)
#else
#define THREAD_CREATE(x,y,z,w) pthread_create(x,y,z,w)
#define THREAD_DETACH(x)  pthread_detach(&x)
#endif

#if defined(_DECTHREADS_) || defined(linux) || defined(_AIX) || defined(bsdi)
#define THREAD_SELF()     0
#else
#define THREAD_SELF()     pthread_self()
#endif
#define THREAD_EXIT(x)    pthread_exit(NULL)

#else
#undef  USE_THREADS
#endif
#endif

#ifdef USE_THREADS
#define IFTHREADED(x)     x
#else

typedef int MUTEX_T;
#define MUTEX_INITIALIZER 0

#define MUTEX_LOCK(x)
#define MUTEX_UNLOCK(x)
#define IFTHREADED(x)     

#define THREAD_SELF()  0
#define THREAD_EXIT(x) exit(x)


#endif /* ! use threads */
#endif /* ! mutex_h */




