/* Copyright (c) 1995,1996,1997 NEC Corporation.  All rights reserved.       */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: addr.h,v 1.10.4.1 1998/06/29 22:42:02 salman Exp $
 */

#ifndef ADDR_H
#define ADDR_H

/* for convenience and space's sake... */
#ifdef HAVE_NETINET6_IN6_H
typedef struct sockaddr_in6  ssi6;
#endif
typedef struct sockaddr_name ssn;
typedef struct sockaddr_in   ssi;
typedef struct sockaddr      ss;
typedef struct msghdr      ms;

extern void    lsAddrSetPort  P((S5NetAddr *na,     u_short port)); 
extern void    lsAddrCopy     P((S5NetAddr *,       const S5NetAddr *, int));
extern int     lsAddrIsNull   P((const S5NetAddr *));
extern int     lsAddrComp     P((const S5NetAddr *, const S5NetAddr *));
extern int     lsAddrSize     P((const S5NetAddr *));

extern int     lsAddrAddrComp P((const S5NetAddr *, const S5NetAddr *));
extern int     lsAddrAddrSize P((const S5NetAddr *));

extern u_short     lsAddr2Port  P((const S5NetAddr *na));
extern const char *lsAddr2Ascii P((const S5NetAddr *na));
extern const char *lsAddr2Ptr   P((const S5NetAddr *na));
    
int lsName2Addr P((const char *, S5NetAddr *));
int lsName2Port P((const char *, const char *, u_short *));

#define ADDRANDPORT(x)     lsAddr2Ascii((x)), ntohs(lsAddr2Port((x)))

#ifdef HAVE_NETINET6_IN6_H
#define ISINET(x) (((x)->sa_family == AF_INET) || ((x)->sa_family == AF_INET6))
#else
#define ISINET(x) ((x)->sa_family == AF_INET)
#endif

#ifdef AF_UNSPEC
#define ISUNSPEC(x) ((x)->sa_family == AF_UNSPEC)
#else
#define ISUNSPEC(x) ((x)->sa_family == 0)
#endif

#endif
