/* Copyright (c) 1995,1996,1997 NEC Corporation.  All rights reserved.       */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: null.c,v 1.24 1997/06/16 15:29:40 steve Exp $
 */

#include "socks5p.h"
#include "threads.h"
#include "addr.h"
#include "log.h"

int lsNullSrvAuth(S5IOHandle fd, S5AuthInfo *ainfo, char *name) {
    extern int IdentQuery P((int, char *));
    char idtname[S5_NAME_SIZE], *ev = NULL;
    int ival = 0;

#ifndef IN_LIBRARY
    IFTHREADED(extern MUTEX_T env_mutex;)
    idtname[0] = '\0';
    ival = IdentQuery(fd, idtname);

    MUTEX_LOCK(env_mutex);
    ev = getenv("SOCKS5_DEMAND_IDENT");
    MUTEX_UNLOCK(env_mutex);
#endif

    if (ev) {
	if (ival < 0) return AUTH_FAIL;
	if (name && *name != '\0' && strcmp(name, idtname)) return AUTH_FAIL;
    }

    if (name && *name == '\0' && *idtname != '\0') strcpy(name, idtname);
    return AUTH_OK;
}

int lsNullCliAuth(S5IOHandle fd, S5AuthInfo *ainfo, char *name) {
    return AUTH_OK;
}
