#include	"precompile.h"
#include	"view.h"
#include	"cube.h"
#include	"bsptree_3d.h"
#include	"transform_3d.h"
#include	"pi.h"

//------------------------------------------------------------------------------
#define	CLASS_NAME	"BSP Tree Demo"																							//	name of the window class and menu name

//------------------------------------------------------------------------------
static	MSG			gMessage;																												//	place to get a message
static	HWND		gWindow;																												//	global handle to the window structure
static	Bool		gClick = FALSE;
static	view		*gView;
bsptree					*world;

//------------------------------------------------------------------------------
void	InitializeModel (void)
{
	world = new bsptree;
	world->Insert (Cube (Scale (R(0.75), R(1.0), R(1.0)) * Translate (R(-0.25), R(0.0), R(0.0))), HC_OUT, HC_OUT);
	world->Insert (Cube (Scale (R(-1.0), R(-0.75), R(-1.25)) * Translate (R(0.25), R(0.0), R(0.0))), HC_IN, HC_SPANNING);
	world->Reduce ();
	world->Insert (Cube (Scale (R(0.5), R(0.75), R(0.5)) * RotateY (R(-15.0)) * Translate (R(0.25), R(0.75), R(0.0))), HC_OUT, HC_SPANNING);
	world->Reduce ();
	world->Insert (Cube (Scale (R(1.25), R(0.35), R(0.25))), HC_OUT, HC_SPANNING);
	world->Reduce ();
}

//------------------------------------------------------------------------------
long FAR PASCAL	WinProc (HWND window, UINT message, WPARAM wpar, LPARAM lpar)		//	window proc for the application window
{																																								//	begin
	switch (message)																															//	check the message
	{																																							//	begin
		case WM_MOUSEMOVE:
			if (gClick)
			{
				POINT	pt;
				pt.x = LOWORD (lpar);
				pt.y = HIWORD (lpar);
				gView->HandleDrag (pt);
			}
			break;
		case WM_LBUTTONDOWN:
			{
			ShowCursor (FALSE);
			gClick = TRUE;
			POINT	pt;
			pt.x = LOWORD (lpar);
			pt.y = HIWORD (lpar);
			gView->HandleClick (pt);
			}
			return 0;
		case WM_LBUTTONUP:
			gClick = FALSE;
			gView->StartDrawing ();
			gView->DrawScene ();
			gView->StopDrawing ();
			ShowCursor (TRUE);
			return 0;
		case WM_KEYDOWN:																														//	key pressed message
			if (wpar == VK_ESCAPE)																										//	if the key is the escape key
			{
				delete gView;
				PostMessage (window, WM_CLOSE, 0, 0);																		//	close the window
			}
			break;																																		//	end case
		case WM_DESTROY:																														//	destroy the window
			PostQuitMessage (0);																											//	quit
			break;																																		//	end case
	}																																							//	end
	return DefWindowProc (window, message, wpar, lpar);														//	default window behavior
}																																								//	end

//------------------------------------------------------------------------------
static	void	Open (HINSTANCE instance, int show)																//	initialize the application
{																																								//	begin
	DefinePI ();																																	//	define the mathematical relationship known as PI
	WNDCLASS	wClass;																															//	window class definition
	wClass.style = CS_HREDRAW | CS_VREDRAW;																				//	style flags
	wClass.lpfnWndProc = WinProc;																									//	set the window proc
	wClass.cbClsExtra = 0;																												//	no extra data
	wClass.cbWndExtra = 0;																												//	no extra data
	wClass.hInstance = instance;																									//	the application instance
	wClass.hIcon = LoadIcon (instance, IDI_APPLICATION);													//	generic application
	wClass.hCursor = LoadCursor (0, IDC_ARROW);																		//	normal cursor
	wClass.hbrBackground = 0;																											//	no background
	wClass.lpszMenuName = CLASS_NAME;																							//	class name
	wClass.lpszClassName = CLASS_NAME;																						//	class name
	RegisterClass (&wClass);																											//	register the class
	gWindow = CreateWindowEx (WS_EX_TOPMOST, CLASS_NAME, CLASS_NAME, WS_POPUP, 0, 0, GetSystemMetrics (SM_CXSCREEN), GetSystemMetrics (SM_CYSCREEN), 0,0, instance, 0);//	create the window
	ShowWindow (gWindow, show);																										//	show the window
	UpdateWindow (gWindow);																												//	update the window
	SetFocus (gWindow);																														//	set the window focus to my window
	InitializeModel ();
	gView = new view (gWindow);
}																																								//	end

//------------------------------------------------------------------------------
static	void	Loop (void)																												//	the main application loop
{																																								//	begin
	Bool	done = FALSE;																														//	the done flag
	while (!done)																																	//	loop until we are done
		if (PeekMessage (&gMessage, 0, 0, 0, PM_NOREMOVE))													//	if there is a message in the queue
			if (GetMessage (&gMessage, gWindow, 0, 0) == TRUE)												//	if the message is not a quit message
				DispatchMessage (&gMessage);																						//	send the message to the appropriate window
			else																																			//	otherwise we want to quit
				done = TRUE;																														//	set the finished flag
		else																																				//	otherwise, the application is not active
			WaitMessage ();																														//	just wait for a message
}																																								//	end

//------------------------------------------------------------------------------
static	void	Close (void)																											//	close the application
{																																								//	begin
}																																								//	end

//------------------------------------------------------------------------------
int PASCAL	WinMain (HINSTANCE inst, HINSTANCE prev, LPSTR cmdLine, int show)		//	windows main
{																																								//	begin
	Open (inst, show);																														//	open the application
	Loop ();																																			//	do the main loop
	Close ();																																			//	close the application
	return TRUE;																																	//	return success
}																																								//	end

//------------------------------------------------------------------------------
