//------------------------------------------------------------------------------
//	File:					pi.cpp
//	Date:					08/06/96
//	Author:				Bretton Wade
//
//	Description:	this file contains the definitions needed for all the code
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//	ANSI Headers
//------------------------------------------------------------------------------
#include <stdio.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <stdarg.h>

//------------------------------------------------------------------------------
//	types
//------------------------------------------------------------------------------
typedef	unsigned int		uint;																										//	abbreviation
typedef	unsigned short	ushort;																									//	abbreviation
typedef	unsigned long		ulong;																									//	abbreviation
typedef	unsigned char		uchar;																									//	abbreviation
typedef	char						*cstr;																									//	a C style string (NULL terminated)
typedef	uchar						*pstr;																									//	a pascal style string (preceded by a length byte)
typedef	uchar						*uPtr;																									//	unsigned char pointer


//------------------------------------------------------------------------------
//	Stuff for boolean type
//------------------------------------------------------------------------------
typedef	ulong						Bool;																										//	boolean type
#ifndef	TRUE																																		//	if the macro TRUE is undefined
enum	{FALSE = 0, TRUE = 1};																										//	enumerate the values of TRUE and FALSE
#endif																																					//	end if

//------------------------------------------------------------------------------
//	real number type and interfaces
//------------------------------------------------------------------------------
#define	USE_FLOATS	0																														//	whether or not the real type is a float
#if	USE_FLOATS == 1																															//	if the real type is a float
typedef	float						real;																										//	common name for floating point type
#define	R(num)	real (num ## F)																									//	want constants to have an F after them to specify float types
#else																																						//	otherwise, use the double versions
typedef	double					real;																										//	common name for floating point type
#define	R(num)	real (num)																											//	want constants to have an L after them to specify long double types
#endif																																					//	end real type is a float
#define	COS(x)			real (cos (real (x)))																				//	use normal version of function
#define	ACOS(x)			real (acos (real (x)))																			//	use normal version of function
#define	SIN(x)			real (sin (real (x)))																				//	use normal version of function
#define	ASIN(x)			real (asin (real (x)))																			//	use normal version of function
#define	TAN(x)			real (tan (real (x)))																				//	use normal version of function
#define	ATAN(x)			real (atan (real (x)))																			//	use normal version of function
#define	ATAN2(y, x)	real (atan2 (real (y), real (x)))														//	use normal version of function
#define	SQRT(x)			real (sqrt (real (x)))																			//	use normal version of function
#define	FABS(x)			real (fabs (real (x)))																			//	use normal version of function
#define	POW(x)			real (pow (real (x)))																				//	use normal version of function
#define	FLOOR(x)		real (floor (real (x)))																			//	use normal version of function

//------------------------------------------------------------------------------
//	math constants
//------------------------------------------------------------------------------
#define	EPSILON			R(1.0e-10)																									//	a very small value
#define	ZERO				R(0.0)																											//	zero
#define	INFINITY		R(1.0e10)																										//	a very big value

//------------------------------------------------------------------------------
