.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutCopyColormap 3GLUT "3.4" "GLUT" "GLUT"
.SH NAME
glutCopyColormap - copies the logical colormap for the layer in use
from a specified window to the current window. 
.SH SYNTAX
.nf
.LP
void glutCopyColormap(int win);
.fi
.SH ARGUMENTS
.IP \fIwin\fP 1i
The identifier of the window to copy the logical colormap from. 
.SH DESCRIPTION
glutCopyColormap copies (lazily if possible to promote sharing) the
logical colormap from a specified window to the current window's layer
in use. The copy will be from the normal plane to the normal plane; or
from the overlay to the overlay (never across different layers). Once a
colormap has been copied, avoid setting cells in the colormap with
glutSetColor since that will force an actual copy of the colormap if it
was previously copied by reference. glutCopyColormap should only
be called when both the current window and the win window are color
index windows. 
.SH EXAMPLE
Here is an example of how to create two color index GLUT windows with
their colormaps loaded identically and so that the windows are
likely to share the same colormap:
.nf
.LP
  int win1, win2;

  glutInitDisplayMode(GLUT_INDEX);
  win1 = glutCreateWindow("first color index win");
  glutSetColor(0, 0.0, 0.0, 0.0);  /* black */
  glutSetColor(1, 0.5, 0.5, 0.5);  /* gray */
  glutSetColor(2, 1.0, 1.0, 1.0);  /* black */
  glutSetColor(3, 1.0, 0.0, 0.0);  /* red */
  win2 = glutCreateWindow("second color index win");
  glutCopyColormap(win1);
.fi
.LP
.SH SEE ALSO
glutSetColor, glutGetColor, glutCreateWindow
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
