.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutGetColor 3GLUT "3.4" "GLUT" "GLUT"
.SH NAME
glutGetColor - retrieves a red, green, or blue component for a given
color index colormap entry for the layer in use's logical colormap for the
current window. 
.SH SYNTAX
.nf
.LP
GLfloat glutGetColor(int cell, int component);
.fi
.SH ARGUMENTS
.IP \fIcell\fP 1i
Color cell index (starting at zero).
.IP \fIcomponent\fP 1i
One of GLUT_RED, GLUT_GREEN, or GLUT_BLUE. 
.SH DESCRIPTION
glutGetColor retrieves a red, green, or blue component for a given
color index colormap entry for the current window's logical colormap.
The current window should be a color index window. cell should be
zero or greater and less than the total number of colormap entries for the
window. For valid color indices, the value returned is a floating point
value between 0.0 and 1.0 inclusive. glutGetColor will return -1.0 if
the color index specified is an overlay's transparent index, less than zero,
or greater or equal to the value returned by
glutGet(GLUT_WINDOW_COLORMAP_SIZE), that is if the color index
is transparent or outside the valid range of color indices. 
.SH SEE ALSO
glutGet, glutSetColor, glutCopyColormap
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
