.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutOverlayDisplayFunc 3GLUT "3.4" "GLUT" "GLUT"
.SH NAME
glutOverlayDisplayFunc - sets the overlay display callback for the current window. 
.SH SYNTAX
.nf
.LP
void glutOverlayDisplayFunc(void (*func)(void));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new overlay display callback function. 
.SH DESCRIPTION
glutDisplayFunc sets the overlay display callback for the current
window. The overlay display callback is functionally the same as the
window's display callback except that the overlay display callback is used
to redisplay the window's overlay. 

When GLUT determines that the overlay plane for the window needs to
be redisplayed, the overlay display callback for the window is called.
Before the callback, the current window is set to the window needing to be
redisplayed and the layer in use is set to the overlay. The overlay display
callback is called with no parameters. The entire overlay region should be
redisplayed in response to the callback (this includes ancillary buffers if
your program depends on their state). 

GLUT determines when the overlay display callback should be triggered
based on the window's overlay redisplay state. The overlay redisplay state
for a window can be either set explicitly by calling
glutPostOverlayRedisplay or implicitly as the result of window
damage reported by the window system. Multiple posted overlay
redisplays for a window are coalesced by GLUT to minimize the number
of overlay display callbacks called. 

Upon return from the overlay display callback, the overlay damaged state
of the window (returned by calling
glutLayerGet(GLUT_OVERLAY_DAMAGED) is cleared. 

The overlay display callback can be deregistered by passing NULL to
glutOverlayDisplayFunc. The overlay display callback is initially
NULL when an overlay is established. See glutDisplayFunc to
understand how the display callback alone is used if an overlay display
callback is not registered.
.SH SEE ALSO
glutDisplayFunc, glutPostOverlayRedisplay
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
