/*
 *	simple_stereo.c
 *	Left mouse can rotate molecule
 *	Middle mouse toggles stereo (Do % man setmon)
 *
 *      cc -xansi simple_stereo.c -lGLw -lGL -lGLU -lXm_s \
 *	-lSgt -lXt_s -lXext -lX11 -lPW -lgutil -o simple_stereo
 */

#include <stdio.h>

#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <X11/extensions/SGIStereo.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>
#include <X11/GLw/GLwMDrawA.h>

#define Color_Buffer_Size		1
#define Depth_Buffer_Size		1

int					sphere_slices = 16,
					sphere_stacks = 16,
					xRot = 0, yRot = 0,
					prevy = 0, prevx = 0,
					nan_stereo_flag = 0;


void					initCB(Widget, XtPointer, XtPointer),
					exposeCB(Widget, XtPointer, XtPointer),
					resizeCB(Widget, XtPointer, XtPointer);

void					SceneDraw(Display *, Window),
					nanWireSpheref(float, float, float, float),
					nanSolidSpheref(float, float, float, float);

void 					start_rtn(Widget, XEvent *),
					rtn(Widget, XEvent *),
					end_rtn(Widget, XEvent *),
					stereoEnable(Widget, XEvent *);



main(int argc, char **argv)
{
  XtAppContext		application_context;
  Widget		toplevel, glw;
  Arg			args[10];
  int 			n = 0;
  GLXContext		glw_context;
  XtTranslations	trans;
  String 		fallback[] = {
    				      "*frame*shadowType: SHADOW_IN",
				      "*boiler*width: 400",
				      "*boiler*height: 400",
				      NULL
				      };
  
  char 			*molTranslations =
  					    "#override\n\
                                	     <Btn1Down>:start_rtn() \n\
                                	     <Btn1Motion>:rtn() \n\
                                	     <Btn1Up>:end_rtn() \n\
					     <Btn2Down>:stereo_on()\n";

  XtActionsRec		actionsTable[] = {
    					  {"start_rtn", start_rtn},
					  {"rtn", rtn},
					  {"end_rtn", end_rtn},
					  {"stereo_on", stereoEnable}
					 };
  
  toplevel = XtAppInitialize(&application_context, "BoilerPlate",
			     (XrmOptionDescList) NULL, 0,
			     &argc, (String *)argv,
			     fallback, (ArgList)NULL, 0);

  trans = XtParseTranslationTable(molTranslations);
  XtAppAddActions(application_context, actionsTable, XtNumber(actionsTable));

  n=0;
  XtSetArg(args[n], GLwNrgba, TRUE); n++;
  XtSetArg(args[n], GLwNdoublebuffer, TRUE); n++;
  XtSetArg(args[n], GLwNredSize, Color_Buffer_Size); n++;
  XtSetArg(args[n], GLwNgreenSize, Color_Buffer_Size); n++;
  XtSetArg(args[n], GLwNblueSize, Color_Buffer_Size); n++;
  XtSetArg(args[n], GLwNdepthSize, Depth_Buffer_Size); n++;

  glw = XtCreateWidget("boiler", glwMDrawingAreaWidgetClass, 
		       toplevel, args, n);
  
  XtAddCallback(glw, GLwNginitCallback, initCB, &glw_context);
  XtAddCallback(glw, GLwNexposeCallback, exposeCB, &glw_context);
  XtAddCallback(glw, GLwNresizeCallback, resizeCB, &glw_context);

  XtOverrideTranslations(glw, trans);
  XtManageChild(glw);
  
  XtRealizeWidget(toplevel);
  XtAppMainLoop(application_context);
}

void 
initCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Display	*display = XtDisplay(w);
  int		screen = DefaultScreen(display);
  Window	window = XtWindow(w);
  XVisualInfo	*vi;
  GLXContext	*glw_context = (GLXContext *) client_data;
  int 		attributeList[] =   { GLX_RGBA,
				      GLX_DOUBLEBUFFER,
				      GLX_RED_SIZE, Color_Buffer_Size,
				      GLX_GREEN_SIZE, Color_Buffer_Size,
				      GLX_BLUE_SIZE, Color_Buffer_Size,
				      GLX_DEPTH_SIZE, Depth_Buffer_Size,
				      None };
 float		mat_specular[] = { .72, .8, .93, 1.0 };

  vi = glXChooseVisual(display, screen, attributeList);
  *glw_context = glXCreateContext(display, vi, None, GL_TRUE);
  glXMakeCurrent(display, window, *glw_context);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(60.0,  1.0,  .25,  15.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0.0, 0.0, -6.0);

  glDepthFunc(GL_LEQUAL);
  glEnable(GL_DEPTH_TEST);
  
  glClearColor(0.0, 0.0, 0.0, 1.0);
  glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
  glXSwapBuffers(display, window);
  glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);

  glEnable(GL_LINE_SMOOTH);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glLineWidth(1.5);

  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 128.0);
  
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);
  glEnable(GL_NORMALIZE);

  SceneDraw(display, window);
}

void
exposeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Display       *display = XtDisplay(w);
  Window	window = XtWindow(w);
  GLXContext    *glw_context = (GLXContext *) client_data;

  glXMakeCurrent(display, window, *glw_context);
  SceneDraw(display, window);
}

void
resizeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Display       *display = XtDisplay(w);
  Window        window = XtWindow(w);
  GLXContext    *glw_context = (GLXContext *) client_data;
  GLwDrawingAreaCallbackStruct *Call_Data = 
    			       (GLwDrawingAreaCallbackStruct *) call_data;
  
  glXMakeCurrent(display, window, *glw_context);
  glViewport(0, 0,
	     (GLuint) Call_Data->width-1,
	     (GLuint) Call_Data->height-1);
  
  SceneDraw(display, window);
}


void SceneDraw(Display *d, Window w)
{
  
  glPushMatrix();
  glRotatef(2.0, 0.0, 1.0, 0.0);
  XSGISetStereoBuffer(d, w, STEREO_BUFFER_LEFT);
  XSync(d, False);
  glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);

  glColor3f(1.0, 1.0, 0.0);
  nanWireSpheref(0.0, 0.0, -1.0, 1.0);

  glColor3f(.5, .5, 5.);
  nanSolidSpheref(0.0, 0.0, 1.0, 1.0);

  glColor3f(1.0, 0.0, 0.0);
  nanSolidSpheref(-1.0, 0.0, 0.0, 1.0);

  glColor3f(0.0, 1.0, 0.0);
  nanSolidSpheref(1.0, 0.0, 0.0, 1.0);

  glColor3f(0.0, 0.0, 1.0);
  nanWireSpheref(0.0, 1.0, 0.0, 1.0);

  glColor3f(1.0, 0.0, 1.0);
  nanWireSpheref(0.0, -1.0, 0.0, 1.0);
  glPopMatrix();

  if(nan_stereo_flag)
    {
      glPushMatrix();
      glRotatef(-2.0, 0.0, 1.0, 0.0);
      XSGISetStereoBuffer(d, w, STEREO_BUFFER_RIGHT);
      XSync(d, False);
      glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);

      glColor3f(1.0, 1.0, 0.0);
      nanWireSpheref(0.0, 0.0, -1.0, 1.0);

      glColor3f(.5, .5, 5.);
      nanSolidSpheref(0.0, 0.0, 1.0, 1.0);

      glColor3f(1.0, 0.0, 0.0);
      nanSolidSpheref(-1.0, 0.0, 0.0, 1.0);

      glColor3f(0.0, 1.0, 0.0);
      nanSolidSpheref(1.0, 0.0, 0.0, 1.0);

      glColor3f(0.0, 0.0, 1.0);
      nanWireSpheref(0.0, 1.0, 0.0, 1.0);

      glColor3f(1.0, 0.0, 1.0);
      nanWireSpheref(0.0, -1.0, 0.0, 1.0);
      glPopMatrix();
    }
	
  glFlush();
  glXSwapBuffers(d, w);
}

void nanSolidSpheref(float x, float y, float z, float radius)
{
  static GLUquadricObj  *quadObj;
  static int            entry = 0;

  glEnable(GL_COLOR_MATERIAL);
  glPushMatrix();
  glTranslatef(x, y, z);
  if (!entry)
    {
      quadObj = gluNewQuadric ();
      gluQuadricDrawStyle (quadObj, GLU_FILL);
      gluQuadricOrientation(quadObj, GLU_OUTSIDE);
      gluQuadricNormals (quadObj, GLU_SMOOTH);
    }
  gluSphere (quadObj, radius, sphere_slices, sphere_stacks);
  glPopMatrix();
  glDisable(GL_COLOR_MATERIAL);
}

void nanWireSpheref(float x, float y, float z, float radius)
{
  static GLUquadricObj  *quadObj;
  static int            entry = 0;

  glEnable(GL_COLOR_MATERIAL);
  glPushMatrix();
  glTranslatef(x, y, z);
  if (!entry)
    {
      quadObj = gluNewQuadric ();
      gluQuadricDrawStyle (quadObj, GLU_LINE);
      gluQuadricOrientation(quadObj, GLU_OUTSIDE);
      gluQuadricNormals (quadObj, GLU_SMOOTH);
    }
  gluSphere (quadObj, radius, sphere_slices, sphere_stacks);
  glPopMatrix();
  glDisable(GL_COLOR_MATERIAL);
}

void start_rtn(Widget w, XEvent *event)
{
  prevx = event->xbutton.x;
  prevy = event->xbutton.y;
}

void rtn(Widget w, XEvent *event)
{
  int x = event->xbutton.x;
  int y = event->xbutton.y;

  yRot +=  5 * (x - prevx);
  xRot +=  5 * (y - prevy);
  prevx = x;
  prevy = y;
  glPushMatrix();
  glRotatef(xRot*0.1, 1.0, 0.0, 0.0);
  glRotatef(yRot*0.1, 0.0, 1.0, 0.0);
  SceneDraw(XtDisplay(w), XtWindow(w));
  glPopMatrix();
}

void
end_rtn(Widget w, XEvent *event)
{
  glPushMatrix();
  glRotatef(xRot*0.1, 1.0, 0.0, 0.0);
  glRotatef(yRot*0.1, 0.0, 1.0, 0.0);
  SceneDraw(XtDisplay(w), XtWindow(w));
  glPopMatrix();
}    

void
stereoEnable(Widget w, XEvent *event)
{
  static	mode = 0;

  nan_stereo_flag = !nan_stereo_flag;
  if(nan_stereo_flag)
    {
      system("/usr/gfx/setmon STR_BOT");
    }
  else
    {
      system("/usr/gfx/setmon 72HZ");
    }
  glPushMatrix();
  glRotatef(xRot*0.1, 1.0, 0.0, 0.0);
  glRotatef(yRot*0.1, 0.0, 1.0, 0.0);
  SceneDraw(XtDisplay(w), XtWindow(w));
  glPopMatrix();
}
