/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import vcpmaint.MVCPGlobals;

public abstract class ComponentCanvas
extends Canvas
implements MVCPGlobals {
    public String name;
    protected String mode;
    protected Dimension mySize;
    protected Image myIcon;
    protected Color currentColor = Color.white;
    protected Color textColor = MVCPGlobals.mcpLtGray;
    protected int overallWidth;
    protected FontMetrics fm;
    protected int fontHeight;
    static final Font reallySmallFont = new Font("SansSerif", 0, 9);
    public static final int arrowLen = 20;
    public static final int boxLeft = 22;
    protected static final int textHeight = 20;
    protected static final int iconAreaWidth = 58;
    protected static final int firstRowY = 6;
    protected static final int secondRowY = 26;
    protected static final int wideColWidth = 200;
    protected static final int thinColWidth = 100;
    protected static final int firstColX = 82;
    protected static final int secondColX = 282;
    protected static final int thirdColX = 382;
    protected static final boolean DEBUG = true;

    public ComponentCanvas(Image image, Color color, int n) {
        this(image, color, MVCPGlobals.mcpLtGray, n);
    }

    public ComponentCanvas(Image image, Color color, Color color2, int n) {
        this.myIcon = image;
        this.currentColor = color;
        this.textColor = color2;
        this.overallWidth = n;
        this.mySize = new Dimension(this.overallWidth, this.getHeight());
        this.setSize(this.mySize);
    }

    public void paint(Graphics graphics) {
        Point point;
        if (this.fm == null) {
            graphics.setFont(MVCPGlobals.textFont);
            this.fm = graphics.getFontMetrics();
            this.fontHeight = this.fm.getMaxAscent();
        }
        int n = this.overallWidth - 22;
        graphics.setColor(this.currentColor);
        graphics.fillRect(22, 0, n, this.getHeight());
        graphics.setColor(this.textColor);
        graphics.setFont(MVCPGlobals.textFont);
        FontMetrics fontMetrics = this.fm;
        int n2 = this.fontHeight;
        String string = this.fitString(this.name, 58, fontMetrics);
        if (string.length() < this.name.length()) {
            graphics.setFont(MVCPGlobals.smallFont);
            fontMetrics = graphics.getFontMetrics();
            n2 = fontMetrics.getMaxAscent();
            string = this.fitString(this.name, 58, fontMetrics);
            if (string.length() < this.name.length()) {
                graphics.setFont(reallySmallFont);
                fontMetrics = graphics.getFontMetrics();
                n2 = fontMetrics.getMaxAscent();
                string = this.fitString(this.name, 58, fontMetrics);
            }
        }
        if (string != null && (point = this.getCenteredPosition(string, 58, fontMetrics, n2)) != null) {
            graphics.drawString(string, point.x + 22, 20 - point.y);
        }
        if (this.myIcon != null) {
            int n3 = Math.max(0, (58 - this.myIcon.getWidth(null)) / 2);
            graphics.drawImage(this.myIcon, 22 + n3, 19, this);
        }
        if (this.mode.equals("BOTH") || this.mode.equals("IN")) {
            this.drawRightArrow(graphics, 1, 31);
        }
        if (this.mode.equals("BOTH") || this.mode.equals("OUT")) {
            this.drawLeftArrow(graphics, 1, 42);
        }
    }

    private String fitString(String string, int n, FontMetrics fontMetrics) {
        try {
            if (fontMetrics.stringWidth(string) < n) {
                return string;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("caught array exception in fitString, text=" + string);
        }
        int n2 = string.length();
        while (n2 > 0) {
            String string2 = string.substring(0, n2);
            if (fontMetrics.stringWidth(string2) < n) {
                return string2;
            }
            --n2;
        }
        return null;
    }

    private Point getCenteredPosition(String string, int n, FontMetrics fontMetrics, int n2) {
        int n3 = fontMetrics.stringWidth(string);
        if (n3 >= n) {
            n3 = n;
        }
        if (n2 >= 20) {
            n2 = 20;
        }
        return new Point((n - n3) / 2, (20 - n2) / 2 + 1);
    }

    protected void drawStringInBox(Graphics graphics, String string, Rectangle rectangle) {
        if (graphics == null || rectangle == null) {
            return;
        }
        Image image = this.createImage(rectangle.width + 1, rectangle.height + 1);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(this.currentColor);
        graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2.setColor(this.textColor);
        graphics2.drawRect(0, 0, rectangle.width, rectangle.height);
        if (this.fm != null && string != null && string.length() > 0) {
            int n = this.fontHeight;
            graphics2.setFont(MVCPGlobals.textFont);
            String string2 = this.fitString(string, rectangle.width, this.fm);
            if (string2.length() < string.length()) {
                graphics2.setFont(MVCPGlobals.smallFont);
                FontMetrics fontMetrics = graphics2.getFontMetrics();
                n = fontMetrics.getMaxAscent();
                string2 = this.fitString(string, rectangle.width, fontMetrics);
            }
            try {
                graphics2.drawString(string2, 5, 20 - ((20 - n) / 2 + 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("caught array exception in drawstring, strThatFits=" + string2);
            }
        }
        graphics.drawImage(image, rectangle.x, rectangle.y, null);
    }

    protected void drawRightArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(MVCPGlobals.reallyDarkGray);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = n2 + n3;
            graphics.drawLine(n, n4, n + 20, n4);
            graphics.drawLine(n + 20 - 6, n4 - 5, n + 20, n4);
            graphics.drawLine(n + 20 - 6, n4 + 5, n + 20, n4);
            ++n3;
        }
    }

    protected void drawLeftArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(MVCPGlobals.reallyDarkGray);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = n2 + n3;
            graphics.drawLine(n, n4, n + 20, n4);
            graphics.drawLine(n, n4, n + 6, n4 - 5);
            graphics.drawLine(n, n4, n + 6, n4 + 5);
            ++n3;
        }
    }

    public int getRight() {
        return this.getLocation().x + this.overallWidth;
    }

    public int getHeight() {
        if (this.myIcon == null) {
            return 56;
        }
        return this.myIcon.getHeight(null) + 20;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public abstract String getCurrentInfo();
}

