/*
 * Decompiled with CFR 0.152.
 */
package vcpmaint;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Cursor;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import vcpmaint.GridBagLayout2;
import vcpmaint.MVCPGlobals;
import vcpmaint.MVCPMaint;
import vcpmaint.Messenger;
import vcpmaint.ScrollCanvas;
import vcpmaint.SocketMgr;

public abstract class DataPanel
extends Panel
implements MVCPGlobals,
ActionListener,
ItemListener,
Runnable {
    Messenger messenger;
    SocketMgr serverSocket;
    ScrollCanvas drawingCanvas;
    boolean doneLayout;
    Thread animatorThread;
    boolean frozen;
    boolean keepRunning;
    boolean userSaysRun;
    static final int canvasHeight = 220;
    Choice chUpdateTime;
    Button bStartStop;
    Label lPrevUpdateTime;
    int maxUpdates = 20;
    int timeUpdateChoice;
    protected static final String ackString = "ack";
    private static final String strUpdate = "Update every";
    private static final String strPrevUpdateTime = "Time of last update: ";
    private static final String strStart = "Resume Auto Update";
    private static final String strStop = "    Stop Auto Update    ";
    static final String strStillImage = "Automatic updating has stopped; press 'Resume Auto Update' to restart";

    public DataPanel(Messenger messenger) {
        this.messenger = messenger;
        this.doneLayout = false;
        this.frozen = false;
        this.userSaysRun = true;
        this.bStartStop = new Button(strStop);
        this.bStartStop.setFont(MVCPGlobals.buttonFont);
        this.bStartStop.addActionListener(this);
        this.chUpdateTime = new Choice();
        this.chUpdateTime.addItemListener(this);
        this.chUpdateTime.setFont(MVCPGlobals.buttonFont);
        this.chUpdateTime.addItem("2 seconds");
        this.chUpdateTime.addItem("5 seconds");
        this.chUpdateTime.addItem("10 seconds");
        this.chUpdateTime.addItem("30 seconds");
        this.chUpdateTime.addItem("60 seconds");
        this.timeUpdateChoice = 5;
        this.chUpdateTime.select(1);
    }

    public void layoutAndShow(ScrollCanvas scrollCanvas) {
        this.drawingCanvas = scrollCanvas;
        this.removeAll();
        GridBagLayout2 gridBagLayout2 = new GridBagLayout2();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout2);
        panel.setBackground(MVCPMaint.backgroundGray);
        Label label = new Label(strUpdate);
        label.setFont(MVCPGlobals.buttonFont);
        this.lPrevUpdateTime = new Label(strPrevUpdateTime + new Date() + "          ");
        this.lPrevUpdateTime.setFont(MVCPGlobals.buttonFont);
        gridBagLayout2.northeast(panel, label, 0, 0, 10, 10, 5, 0);
        gridBagLayout2.northwest(panel, this.chUpdateTime, 1, 0, 10, 0, 5, 10);
        gridBagLayout2.northwest(panel, this.lPrevUpdateTime, 2, 0, 10, 10, 5, 10);
        gridBagLayout2.northwest(panel, this.bStartStop, 0, 1, 2, 1, 0, 10, 10, 10);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel2.add("Center", this.drawingCanvas);
        if (this.drawingCanvas.hbar != null) {
            panel2.add("South", this.drawingCanvas.hbar);
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", panel);
        this.add("Center", panel2);
        this.doneLayout = true;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bStartStop) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.frozen) {
                this.userSaysRun = true;
                this.start();
            } else {
                this.userSaysRun = false;
                this.stop(true);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chUpdateTime) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String string = this.chUpdateTime.getSelectedItem();
            string = string.substring(0, string.indexOf(" "));
            this.timeUpdateChoice = Integer.parseInt(string);
            if (this.animatorThread != null) {
                this.animatorThread.interrupt();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setUpdateTime(Date date) {
        this.lPrevUpdateTime.setText(strPrevUpdateTime + date);
    }

    public abstract boolean contactServer();

    public synchronized void start() {
        if (this.animatorThread != null) {
            return;
        }
        this.frozen = false;
        this.bStartStop.setLabel(strStop);
        if (this.drawingCanvas != null) {
            this.drawingCanvas.setFreeze(false);
        }
        if (this.animatorThread == null) {
            this.animatorThread = new Thread(this);
        }
        try {
            this.animatorThread.start();
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            System.out.println("DataPanel.start, caught IllegalThreadStateException");
            return;
        }
    }

    public synchronized void stop(boolean bl) {
        this.bStartStop.setLabel(strStart);
        this.keepRunning = false;
        if (this.drawingCanvas != null) {
            this.drawingCanvas.setFreeze(true);
        }
        if (!this.frozen) {
            this.frozen = true;
            if (bl && this.animatorThread != null) {
                this.animatorThread.interrupt();
            }
        }
        this.animatorThread = null;
    }

    public void pause() {
        this.stop(true);
    }

    public void unPause() {
        if (this.userSaysRun) {
            this.start();
        }
    }

    public void exit() {
        this.stop(true);
    }

    protected void socketClose() {
        if (this.serverSocket.isOpen()) {
            this.serverSocket.writeToSocket("stop");
            this.serverSocket.closeSocket();
        }
    }

    protected void sleepFor(long l) {
        try {
            if (this.animatorThread != null) {
                Thread.sleep(l);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected long now() {
        return new Date().getTime();
    }

    protected void error(String string) {
        this.messenger.errorMessage(string);
        System.out.println(string);
    }

    public abstract void run();
}

